package com.ericsson.cms.contractmgmt.client.tab.config;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.scheduling.ui.client.data.ScheduleInfo;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author amit.r.seth
 *
 */
public class SchedulePanel extends VerticalContainer {
	
	private IContractManagerServiceAsync contractManagerService = GWT.create( IContractManagerService.class );

	EveryDayRow schedulingWidget;
	private ScheduleTab parent;

	public SchedulePanel(final ScheduleTab parent) {
		this.parent = parent;
		schedulingWidget = new EveryDayRow();
		   
		schedulingWidget.setVisible(true);
		add(schedulingWidget);
		
		final BusyIndicator busyIndicator = new BusyIndicator();
		busyIndicator.center();
		contractManagerService
				.getSchedule(new NeptuneAsyncCallback<ScheduleInfo>() {

					@Override
					public void onNeptuneFailure(Throwable caught) {
						busyIndicator.hide();
						if (caught instanceof ValidationException) {
							ValidationException ve = (ValidationException) caught;
							addWarningMessages(ve.getValidationMessages());
						} else {
							addWarningMessage(caught.getLocalizedMessage());
						}
					}

					@Override
					public void onNeptuneSuccess(ScheduleInfo scheduleInfo) {
						busyIndicator.hide();
						if (scheduleInfo != null) {
							schedulingWidget.setScheduleInfo(scheduleInfo);
							schedulingWidget.setVisible(true);
						}
					}
				});

	}
	
	private void addWarningMessage(String msg) {
		this.parent.addWarningMessage(msg);
	}

	private void addWarningMessages(List<String> msgs) {
		for (String msg : msgs) {
			this.parent.addWarningMessage(msg);
		}
	}
}
