package com.ericsson.cms.contractmgmt.client.tab.config;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DialogBoxContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * @author amit.r.seth
 *
 */
public class ScheduleTab extends VerticalContainer implements IConfigTabPanel {
	
	private IContractManagerServiceAsync contractManagerService = GWT.create( IContractManagerService.class );

	VerticalContainer warningMessages = new VerticalContainer();
	SchedulePanel schedulePanel = new SchedulePanel(this);
	private RoundedDisclosureContainer schedulePanelContainer;
	
	private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

	private ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create( ContractComponentMessages.class );
	
	private static final String STYLE_NAME = "configuration-panel";

	public ScheduleTab() {
		ButtonWidget saveButton;
		ButtonWidget deleteButton;
		HorizontalContainer buttonContainer = new HorizontalContainer();

		LabelWidget label1 = new LabelWidget();
		add(label1);
		setCellHeight(label1, "10");

		add(warningMessages);

		LabelWidget label2 = new LabelWidget();
		add(label2);
		setCellHeight(label2, "10");
		
		schedulePanelContainer = new RoundedDisclosureContainer(constants.scheduleLabel());
		schedulePanelContainer.setOpen(true);
		schedulePanelContainer.addStyleName(STYLE_NAME);
		schedulePanelContainer.add(schedulePanel);
		add(schedulePanelContainer);

		LabelWidget label3 = new LabelWidget();
		add(label3);
		setCellHeight(label3, "10");

		saveButton = new ButtonWidget(constants.saveButtonName(),
				new ClickHandler() {
					public void onClick(ClickEvent event) {
						clearWarningMessages();
						if (validate()) {
							contractManagerService.saveSchedule(schedulePanel.schedulingWidget.getScheduleInfo(), 
									new NeptuneAsyncCallback<Void>(){

										@Override
										public void onNeptuneFailure(Throwable caught) {
											if ( caught instanceof ValidationException ) {
									            ValidationException ve = (ValidationException) caught;
									            addWarningMessages(ve.getValidationMessages());
									        } else {
									            addWarningMessage(caught.getLocalizedMessage());
									        }
										}

										@Override
										public void onNeptuneSuccess(Void result) {
											addSuccessMessage(messages.saveScheduleSucceeded());
										}});
						}
					}

				});
		saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		buttonContainer.add(saveButton);

		deleteButton = new ButtonWidget(constants.deleteButtonName(),
				new ClickHandler() {
					public void onClick(ClickEvent event) {
						clearWarningMessages();
						confirm(constants.confirmScheduleDeletion(),
								new Command() {

									@Override
									public void execute() {
										contractManagerService.saveSchedule(null, 
												new NeptuneAsyncCallback<Void>(){

													@Override
													public void onNeptuneFailure(Throwable caught) {
														if ( caught instanceof ValidationException ) {
												            ValidationException ve = (ValidationException) caught;
												            addWarningMessages(ve.getValidationMessages());
												        } else {
												            addWarningMessage(caught.getLocalizedMessage());
												        }
													}

													@Override
													public void onNeptuneSuccess(Void result) {
														schedulePanel.schedulingWidget.reset();
														addSuccessMessage(messages.deleteScheduleSucceeded());
													}});
									}
								}, new Command() {

									@Override
									public void execute() {
										// Do nothing...

									}
								});
					}

				});
		deleteButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		buttonContainer.add(deleteButton);
		
		add(buttonContainer);
	}
	
	private boolean validate() {
		boolean validateResult = true;
		
		clearWarningMessages();
		List<String> validationMessages = schedulePanel.schedulingWidget.validate();
		if (validationMessages.size() > 0) {
			validateResult = false;
			for (String validationMessage : validationMessages) {
				addWarningMessage(validationMessage);
			}
		}
		
		return validateResult;
	}
	
	private void addSuccessMessage(String msg) {
		LabelWidget message = new LabelWidget(msg);
		this.warningMessages.add(message);
	}

	void addWarningMessage(String msg) {
		LabelWidget message = new LabelWidget(msg);
		message.addStyleName("red-txt");
		this.warningMessages.add(message);
	}

	private void addWarningMessages(List<String> msgs) {
		for (String msg : msgs) {
			addWarningMessage(msg);
		}
	}

	private void clearWarningMessages() {
		this.warningMessages.clear();
	}
	
	private void confirm(String confirmationText, final Command okCommand,
			final Command cancelCommand) {
		final DialogBoxContainer dialogBox = new DialogBoxContainer(false, true);
		dialogBox.setText(confirmationText);

		// yes button
		ButtonWidget yesButton = new ButtonWidget(constants.buttonLabelOk());
		yesButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		yesButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				dialogBox.hide();
				if (okCommand != null) {
					okCommand.execute();
				}
			}
		});

		// no button
		ButtonWidget noButton = new ButtonWidget(constants.cancelButtonName());
		noButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		noButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				dialogBox.hide();
				if (cancelCommand != null) {
					cancelCommand.execute();
				}
			}
		});

		// panel which contains the buttons
		HorizontalContainer buttonPanel = new HorizontalContainer();
		dialogBox.setWidget(buttonPanel);
		buttonPanel.add(yesButton);
		buttonPanel.setCellHorizontalAlignment(yesButton,
				HorizontalPanel.ALIGN_RIGHT);
		buttonPanel.add(noButton);
		buttonPanel.setCellHorizontalAlignment(noButton,
				HorizontalPanel.ALIGN_LEFT);

		dialogBox.center();
		dialogBox.show();
	}

	@Override
	public void setSelected(boolean selected) {
		clearWarningMessages();
	}
}
