package com.ericsson.cms.contractmgmt.client.tab.config;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

/**
 * Converts a value from float to string and vice versa
 * 
 * @author Daniel Paranhos
 */
public class TypedFloatConverter implements IValueConverter<Float> {

    /**
     * Constructor
     */
    public TypedFloatConverter() {
    }

    @Override
    public String getStringValue( Float typedValue ) {
        return ( typedValue == null ) ? null : typedValue.toString();
    }

    @Override
    public Float getTypedValue( String value ) throws ValueFormatException {
        Float result = null;

        try {
            if ( value != null && value.trim().length() > 0 ) {
                result = new Float( value.trim() );
            }
            if ( ( result != null ) && ( result < 0 ) ) {
                throw new ValueFormatException( value + " is not a valid float." );
            }
        } catch ( NumberFormatException nfe ) {
            throw new ValueFormatException( value + " is not a valid float." );
        }

        return result;
    }
}
