package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

/**
 * Represents a user defined field record in the user defined field list view.
 * 
 * @author Daniel Paranhos
 * 
 */
public class UiUserDefinedFieldRecord implements Record<Long> {

    private UiUserDefinedField userDefinedField;

    public UiUserDefinedFieldRecord() {
    }

    public UiUserDefinedFieldRecord( UiUserDefinedField userDefinedField ) {
        super();
        this.userDefinedField = userDefinedField;
    }

    @Override
    public Long getKey() {
        return userDefinedField.getIdUserDefinedField();
    }

    /**
     * @return the contract
     */
    public UiUserDefinedField getUserDefinedField() {
        return userDefinedField;
    }

    /**
     * @param contract
     *            the contract to set
     */
    public void setUserDefinedField( UiUserDefinedField userDefinedField ) {
        this.userDefinedField = userDefinedField;
    }

}
