package com.ericsson.cms.contractmgmt.client.tab.config;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.HelpWidget;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldValidator;
import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.CurrencyListPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.custom.CustomListPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic.GenericListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.RadioButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class UserDefinedFieldDetailView extends Composite implements
DetailView<Long, UiUserDefinedFieldRecord> {

    private static final String PANEL_STYLE = "configuration-panel";
    /* The default dependent style name to use for widgets in error state */
    private static final String ERROR_STYLE = "dataTypeError";

    private static final int MIN_LENGTH = 0;
    private static final int MAX_LENGTH = 50;
    private static final int MAX_INT_VALUE = 50;

    private final UiUserDefinedFieldRecord record;
    private final VerticalContainer mainContainer;

    private final ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    private final ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create( ContractComponentMessages.class );

    private final ContractFormContainer formContainer = new ContractFormContainer(
            HasHorizontalAlignment.ALIGN_LEFT );
    private final TextBoxWidget nameTextBox = new TextBoxWidget();
    private TypedListBoxWidget<Long> fieldTypeListBox;
    private RadioButtonWidget requiredYes;
    private RadioButtonWidget requiredNo;
    private DataTypeWidget<?> defaultValueWidget = null;
    private RadioButtonWidget dropDown;
    private RadioButtonWidget freeType;
    private TypedTextBoxWidget<Integer> maxCharsTextBox;
    private TypedTextBoxWidget<Integer> minCharsTextBox;
    private TypedTextBoxWidget<Integer> orderTextBox;
    private int fillTypeRow;
    private int minCharsRow;
    private int maxCharsRow;
    private int dropDownTableRow;
    private int defaultValueRow;
    private boolean hasFillType = false;
    private boolean hasValidation = false;
    private boolean hasDropDownTable = false;
    private boolean hasDefaultValueRow = false;
    private ButtonWidget saveButton;
    private final List<UiKeyName> fieldTypes = new ArrayList<UiKeyName>();

    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT
            .create( IContractManagerDropDownService.class );
    private final UserDefinedFieldListPanel parentPanel;
    private CustomListPanel customListPanel = null;
    private GenericListPanel frequencyListPanel = null;
    private CurrencyListPanel currencyListPanel = null;
    private final DefaultValueWidgetFactory dvFactory = new DefaultValueWidgetFactory();

    public UserDefinedFieldDetailView( UserDefinedFieldListPanel parentPanel,
            final UiUserDefinedFieldRecord record,
            final DetailViewCallback<Long, UiUserDefinedFieldRecord> callback ) {
        this.parentPanel = parentPanel;
        this.record = record;

        mainContainer = new VerticalContainer();
        mainContainer.setStyleName( PANEL_STYLE );

        contractManagerDropDownService.getFieldTypeKeyNameList( new NeptuneAsyncCallback<List<UiKeyName>>() {

            @Override
            public void onNeptuneFailure( Throwable caught ) {
                // TODO Auto-generated method stub
            }

            @Override
            public void onNeptuneSuccess( List<UiKeyName> result ) {
                fieldTypes.addAll( result );
                initForm( record, callback );
            }
        } );
    }

    /**
     * @param record
     * @param callback
     */
    @SuppressWarnings("unchecked")
    private void initForm( UiUserDefinedFieldRecord record,
            final DetailViewCallback<Long, UiUserDefinedFieldRecord> callback ) {

        final UiUserDefinedField field = record.getUserDefinedField();

        nameTextBox.setText( field.getLabel() );
        formContainer.addRow( constants.configurationNameColumn(), nameTextBox, true );

        fieldTypeListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );
        fieldTypeListBox.addValueChangeHandler( new ValueChangeHandler<Long>() {

            @Override
            public void onValueChange( ValueChangeEvent<Long> event ) {
                int value = -1;
                if ( event.getValue() != null ) {
                    value = event.getValue().intValue();
                }

                if ( hasDropDownTable ) {
                    formContainer.removeRow( dropDownTableRow );
                    hasDropDownTable = false;
                }
                if (hasDefaultValueRow) {
                    formContainer.removeRow(defaultValueRow);
                    hasDefaultValueRow = false;
                }
                if ( hasValidation ) {
                    removeValidationRows();
                }
                if ( hasFillType ) {
                    formContainer.removeRow( fillTypeRow );
                    hasFillType = false;
                }

                if ( value == FieldTypeEnum.Alphanumeric.ordinal()
                        || value == FieldTypeEnum.Text.ordinal() ) {
                    addFillTypeRow(field.getIdUserDefinedField() != null);
                    addValidationRows();
                } else if ( value == FieldTypeEnum.Frequency.ordinal()
                        || value == FieldTypeEnum.Currency.ordinal() ) {
                    addFillTypeRow(field.getIdUserDefinedField() != null);
                    freeType.setEnabled( false );
                    dropDown.setValue( true );
                }


                if ( value >= 0 ) {
                    addDropDownTable( FieldTypeEnum.values()[value] );
                }

            }

        } );
        fieldTypeListBox.addItem( "", null );
        for ( UiKeyName keyName : fieldTypes ) {
            fieldTypeListBox.addItem( keyName.getName(), keyName.getKey() );
        }
        if ( field.getType() != null ) {
            fieldTypeListBox.setValue( (long) field.getType().ordinal() );
        }
        if (field.getIdUserDefinedField() != null) {
            fieldTypeListBox.setEnabled(false);
        }
        formContainer.addRow( constants.configurationFieldTypeColumn(), fieldTypeListBox, true );

        requiredYes = new RadioButtonWidget( "required", constants.yes() );
        requiredNo = new RadioButtonWidget( "required", constants.no() );
        boolean req = field.isRequired() != null ? field.isRequired() : false;
        HorizontalContainer requiredContainer = createRadioContainer( requiredYes, requiredNo, req ? requiredYes : requiredNo );
        formContainer.addRow( constants.configurationRequiredColumn(), requiredContainer );

        orderTextBox = new TypedTextBoxWidget<Integer>( new PositiveIntegerConverter() );
        orderTextBox.setValue( field.getOrder() );
        orderTextBox.setErrorToolTip(messages.positiveNumberValidationErrorTooltip());
        formContainer.addRow( constants.configurationOrderColumn(), orderTextBox );

        if ( FieldTypeEnum.Alphanumeric.equals( field.getType() )
                || FieldTypeEnum.Text.equals( field.getType() ) ) {
            addFillTypeRow(field.getIdUserDefinedField() != null);
            dropDown.setValue( field.isDropDown() );
            if ( !field.isDropDown() ) {
                addValidationRows();
            }
        } else if ( FieldTypeEnum.Currency.equals( field.getType() )
                || FieldTypeEnum.Frequency.equals( field.getType() ) ) {
            addFillTypeRow(field.getIdUserDefinedField() != null);
            freeType.setEnabled( false );
            dropDown.setValue( field.isDropDown() );
        }

        if ( field.isDropDown() != null && field.isDropDown() ) {
            addDropDownTable( field.getType() );
        } else {
            // If editing then need to get the current widget, not Text.
            defaultValueWidget = dvFactory.createDefaultValueWidget(field.getType() == null ? FieldTypeEnum.Text : field.getType(), dropDown == null ? false : dropDown.getValue(), null, null, field.getMaxChars() == null ? MAX_LENGTH : field.getMaxChars());
            if ( field.getDefaultValue() != null ) {
                defaultValueWidget.setTextValue( field.getDefaultValue() );
            }
            if(defaultValueWidget instanceof TypedTextBoxWidget){
                ((TypedTextBoxWidget)defaultValueWidget).setMaxLength(MAX_INT_VALUE);

            }

            defaultValueRow = formContainer.addRow( constants.configurationDefaultValueColumn(), defaultValueWidget );
            hasDefaultValueRow = true;
        }

        saveButton = new ButtonWidget( constants.saveButtonName(), new ClickHandler() {
            @Override
            public void onClick( ClickEvent event ) {
                parentPanel.clearMessages();
                List<String> validationMessages = new ArrayList<String>();
                validationMessages.add("User defined field has errors - hover over highlighted fields to identify and correct.");
                boolean isFormValid = formContainer.validate();
                boolean isDefaultValueValid = validateDefaultValue(validationMessages);
                if ( isFormValid && isDefaultValueValid ) {
                    callback.save( UserDefinedFieldDetailView.this );
                } else {
                    for ( String message : validationMessages ) {
                        parentPanel.getErrorPanel().addMessage( message );
                    }
                }
            }

        } );
        saveButton.addStyleDependentName( StyleNames.COMMIT_BUTTON_STYLE );
        formContainer.addButton( saveButton );

        ButtonWidget cancelButton = new ButtonWidget( constants.cancelButtonName(), new ClickHandler() {
            @Override
            public void onClick( ClickEvent event ) {
                parentPanel.clearMessages();
                callback.cancel( UserDefinedFieldDetailView.this );
            }
        } );
        cancelButton.addStyleDependentName( StyleNames.DATALOSS_BUTTON_STYLE );
        formContainer.addButton( cancelButton );

        updateWidgetsAccess();
    }

    /**
     * Adds the default value row to the form.
     * 
     * @param maxChars
     * @param fieldType
     * @param uiKeyNamesList
     */
    @SuppressWarnings("unchecked")
    private void addDefaultValueRow(
            FieldTypeEnum fieldType, List<UiKeyName> uiKeyNamesList) {
        defaultValueWidget = dvFactory.createDefaultValueWidget(fieldType, dropDown == null ? false : dropDown.getValue(), uiKeyNamesList, record.getUserDefinedField().getDefaultValue(), null);
        if(defaultValueWidget instanceof TypedTextBoxWidget){
            ((TypedTextBoxWidget)defaultValueWidget).setMaxLength(MAX_INT_VALUE);

        }

        HorizontalContainer defaultRow = new HorizontalContainer();
        defaultRow.add(defaultValueWidget);
        if (dropDown == null ? false : dropDown.getValue()) {
            addSpace(defaultRow);
            defaultRow.add(new HelpWidget(messages.dropDownSelectionAfterSave()));
        }
        defaultValueRow = formContainer.addRow( constants.configurationDefaultValueColumn(), defaultRow );
        hasDefaultValueRow = true;
    }

    private void addSpace(HorizontalContainer container) {
        if (container != null) {
            HorizontalPanel space = new HorizontalPanel();
            LabelWidget label = new LabelWidget();
            space.add(label);
            space.setCellWidth(label, "10");
            container.add(space);
        }
    }

    private void addDropDownTable( final FieldTypeEnum type ) {
        final List<UiKeyName> uiKeyNamesList = new ArrayList<UiKeyName>();
        final BusyIndicator busyIndicator = new BusyIndicator();
        // TODO: Get the drop downs filled with values everytime.
        if ( FieldTypeEnum.Frequency.equals( type ) ) {
            this.frequencyListPanel = new GenericListPanel( ConfigurableFieldTypeEnum.Frequency, !(record.getKey() == null) );
            if (record.getKey() == null) {
                busyIndicator.center();
                contractManagerDropDownService.getGenericDropDownKeyNameList(0, 0, null, true, ConfigurableFieldTypeEnum.Frequency, new NeptuneAsyncCallback<UiKeyNames>() {

                    @Override
                    public void onNeptuneFailure(Throwable caught) {
                        busyIndicator.hide();
                        replaceDefaultValueRow(type, uiKeyNamesList);
                        addFrequencyList();
                    }

                    @Override
                    public void onNeptuneSuccess(UiKeyNames result) {
                        uiKeyNamesList.addAll(result.getRecords());
                        busyIndicator.hide();
                        replaceDefaultValueRow(type, uiKeyNamesList);
                        addFrequencyList();
                    }
                });
            } else {
                uiKeyNamesList.addAll(record.getUserDefinedField().getKeyNames());
                replaceDefaultValueRow(type, uiKeyNamesList);
                addFrequencyList();
            }
        } else if ( FieldTypeEnum.Currency.equals( type ) ) {
            this.currencyListPanel = new CurrencyListPanel(!(record.getKey() == null));
            if (record.getKey() == null) {
                busyIndicator.center();
                contractManagerDropDownService.getCurrencies(new NeptuneAsyncCallback<List<UiCurrency>>() {

                    @Override
                    public void onNeptuneFailure(Throwable caught) {
                        busyIndicator.hide();
                        replaceDefaultValueRow(type, uiKeyNamesList);
                        addCurrencyList();
                    }

                    @Override
                    public void onNeptuneSuccess(List<UiCurrency> result) {
                        for (UiCurrency currency : result) {
                            UiKeyName keyName = new UiKeyName(currency.getKey());
                            keyName.setName(currency.getName()+ " (" + currency.getSymbol() + ")");
                            uiKeyNamesList.add(keyName);
                        }
                        busyIndicator.hide();
                        replaceDefaultValueRow(type, uiKeyNamesList);
                        addCurrencyList();
                    }
                });
            } else {
                uiKeyNamesList.addAll(record.getUserDefinedField().getKeyNames());
                replaceDefaultValueRow(type, uiKeyNamesList);
                addCurrencyList();
            }
        } else if ( ( FieldTypeEnum.Alphanumeric.equals( type ) || FieldTypeEnum.Text.equals( type ) )
                && dropDown.getValue() ) {
            this.customListPanel = new CustomListPanel( record.getKey(), type );
            uiKeyNamesList.addAll(record.getUserDefinedField().getKeyNames());
            addDefaultValueRow(type, uiKeyNamesList);
            dropDownTableRow = formContainer.addRow( "", customListPanel );
            hasDropDownTable = true;
        } else {
            addDefaultValueRow(type, null);
        }

    }

    /**
     * @param type
     * @param uiKeyNamesList
     */
    private void replaceDefaultValueRow(FieldTypeEnum type,
            final List<UiKeyName> uiKeyNamesList) {
        if (hasDefaultValueRow) {
            formContainer.removeRow(defaultValueRow);
            hasDefaultValueRow = false;
        }
        addDefaultValueRow(type, uiKeyNamesList);
    }

    /**
     * 
     */
    private void addFrequencyList() {
        dropDownTableRow = formContainer.addRow( "", frequencyListPanel );
        hasDropDownTable = true;
    }

    /**
     * 
     */
    private void addCurrencyList() {
        dropDownTableRow = formContainer.addRow( "", currencyListPanel );
        hasDropDownTable = true;
    }

    private void addValidationRows() {
        minCharsTextBox = new TypedTextBoxWidget<Integer>( new PositiveIntegerConverter() );
        Integer minChars = record.getUserDefinedField().getMinChars();
        if ( minChars != null ) {
            minCharsTextBox.setValue( minChars );
        }
        minCharsTextBox.setErrorToolTip( messages.positiveNumberValidationErrorTooltip() );
        minCharsRow = formContainer.addRow( constants.configurationMinCharsColumn(), minCharsTextBox );

        maxCharsTextBox = new TypedTextBoxWidget<Integer>( new PositiveIntegerConverter(MAX_INT_VALUE) );
        Integer maxChars = record.getUserDefinedField().getMaxChars();
        if ( maxChars != null ) {
            maxCharsTextBox.setValue( maxChars );
        }
        maxCharsTextBox.setMaxLength(2);
        maxCharsTextBox.setErrorToolTip( messages.maxCharsValidationErrorTooltip(MAX_LENGTH) );
        maxCharsRow = formContainer.addRow( constants.configurationMaxCharsColumn(), maxCharsTextBox );
        hasValidation = true;
    }

    private void removeValidationRows() {
        formContainer.removeRow( maxCharsRow );
        formContainer.removeRow( minCharsRow );
        hasValidation = false;
    }

    private void addFillTypeRow(boolean isEditing) {
        freeType = new RadioButtonWidget( "fillType", constants.freeType() );
        freeType.addValueChangeHandler( new ValueChangeHandler<Boolean>() {

            @Override
            public void onValueChange( ValueChangeEvent<Boolean> event ) {
                if (event.getValue() && !hasValidation) {
                    if (hasDropDownTable) {
                        formContainer.removeRow(dropDownTableRow);
                        hasDropDownTable = false;
                        if (hasDefaultValueRow) {
                            formContainer.removeRow(defaultValueRow);
                            hasDefaultValueRow = false;
                        }
                    }
                    addValidationRows();
                    addDefaultValueRow(FieldTypeEnum.values()[fieldTypeListBox.getValue().intValue()], null);
                }

            }
        } );
        dropDown = new RadioButtonWidget( "fillType", constants.dropDown() );
        dropDown.addValueChangeHandler( new ValueChangeHandler<Boolean>() {

            @Override
            public void onValueChange( ValueChangeEvent<Boolean> event ) {
                if (event.getValue() && hasValidation) {
                    if (hasDefaultValueRow) {
                        formContainer.removeRow(defaultValueRow);
                        hasDefaultValueRow = false;
                    }
                    removeValidationRows();
                    if (fieldTypeListBox.getValue() != null) {
                        addDropDownTable(FieldTypeEnum.values()[fieldTypeListBox.getValue().intValue()]);
                    }
                }
            }
        } );

        if (isEditing) {
            freeType.setEnabled(false);
            dropDown.setEnabled(false);
        }

        HorizontalContainer fillTypeContainer = createRadioContainer( freeType, dropDown, freeType );
        fillTypeRow = formContainer.addRow( constants.configurationFillTypeColumn(), fillTypeContainer );
        hasFillType = true;
    }

    private HorizontalContainer createRadioContainer( RadioButtonWidget radio1, RadioButtonWidget radio2,
            RadioButtonWidget requiredRadio ) {
        HorizontalContainer container = new HorizontalContainer();

        container.add( radio1 );

        HorizontalPanel space = new HorizontalPanel();
        LabelWidget label = new LabelWidget();
        space.add( label );
        space.setCellWidth( label, "10" );
        container.add( space );

        requiredRadio.setValue( true );
        container.add( radio2 );

        return container;
    }

    private boolean validateDefaultValue(List<String> validationMessages) {
        boolean isValid = true;
        // TODO: Test validations and more cleanup
        UiUserDefinedField field = updateUiUserdefinedField();
        CustomFieldValidator.validate( defaultValueWidget, field );
        if ( !defaultValueWidget.isValidValue() || defaultValueWidget.hasValidationError() ) {
            String tooltip = defaultValueWidget.getToolTip();
            if ( tooltip == null ) {
                tooltip = "";
            }
            validationMessages.add( messages.invalidFieldValue( constants.configurationDefaultValueColumn() ) + tooltip );
            isValid = false;
        }
        // TODO: Update validation for the changes
        final String defaultString = defaultValueWidget.getTextValue() != null ? defaultValueWidget.getTextValue().trim() : "";
        if (requiredYes.getValue() && defaultString.equals("")) {
            markRequiredError(defaultValueWidget);
            validationMessages.add(messages.defaultValueRequired());
            isValid = false;
        }
        if (defaultString != null && !defaultString.isEmpty()) {
            FieldTypeEnum type = FieldTypeEnum.values()[fieldTypeListBox.getValue().intValue()];
            if (fieldTypeListBox != null) {
                switch (type) {
                case Number:
                    try {
                        Long.parseLong(defaultString);
                    } catch (Exception e) {
                        validationMessages.add(messages.defaultValueNotNumber(Long.MAX_VALUE));
                        isValid = false;
                    }
                    break;
                case Percentage:
                    try {
                        Float value = Float.parseFloat(defaultString);
                        if (value < 0 || value > 100) {
                            validationMessages.add(messages.defaultValueBetween0And100());
                            isValid = false;
                        }
                    } catch (Exception e) {
                        validationMessages.add(messages.defaultValueNotPercentage());
                        isValid = false;
                    }
                    break;
                case Date:
                    if (!defaultString.isEmpty()) {
                        DateTimeFormat dateFormatter = DateTimeFormat.getFormat(constants.dateFormat());
                        try {
                            dateFormatter.parseStrict(defaultString);
                        } catch (Exception e) {
                            validationMessages.add(messages.defaultValueDateFormat(constants.dateFormat()));
                            isValid = false;
                        }
                    }
                    break;
                }
            }
        }
        if (hasValidation) {
            int minLength = minCharsTextBox != null && minCharsTextBox.getText().trim().length() > 0 ? Integer.parseInt(minCharsTextBox.getText()) : MIN_LENGTH;
            int maxLength = maxCharsTextBox != null && maxCharsTextBox.getText().trim().length() > 0 ? Integer.parseInt(maxCharsTextBox.getText()) : MAX_LENGTH;
            if (maxLength < minLength || maxLength == 0) {
                validationMessages.add(messages.maxGreaterThanMin( maxLength, minLength ));
                isValid = false;
            } else {
                if (defaultString.length() < minLength) {
                    validationMessages.add(messages.defaultValueMinLength(minLength));
                    isValid = false;
                }
                if (defaultString.length() > maxLength) {
                    validationMessages.add(messages.defaultValueMaxLength(maxLength));
                    isValid = false;
                }
            }
        } else {
            if (defaultString.length() > MAX_LENGTH) {
                validationMessages.add(messages.defaultValueMaxLength(MAX_LENGTH));
                isValid = false;
            }
        }
        return isValid;
    }

    private void markRequiredError( Widget widget ) {
        if ( widget instanceof DataTypeWidget<?> ) {
            DataTypeWidget<?> dataTypeWidget = (DataTypeWidget<?>) widget;
            if ( dataTypeWidget.isValidValue() ) {
                dataTypeWidget.showValidationError( messages.fieldRequiredValidationErrorTooltip() );
            }
        } else {
            widget.addStyleDependentName( ERROR_STYLE );
            widget.setTitle( messages.fieldRequiredValidationErrorTooltip() );
        }
    }

    private void updateWidgetsAccess() {
        boolean isCreating = record.getKey() == null;
        nameTextBox.setReadOnly( !isCreating );
        saveButton.setVisible( saveButtonIsVisible( isCreating ) );
    }

    private boolean saveButtonIsVisible( boolean isCreating ) {
        boolean visible = isCreating && ClientAuthorizationManager
                .isAuthorized( Permissions.CONTRACT_CREATE )
                || !isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY );
        return visible;
    }

    @Override
    public void commit() {
        UiUserDefinedField f = updateUiUserdefinedField();
        record.setUserDefinedField(f);
    }

    /**
     * @return
     * @throws NumberFormatException
     */
    private UiUserDefinedField updateUiUserdefinedField() {
        UiUserDefinedField f = record.getUserDefinedField();
        f.setLabel(nameTextBox.getText().trim());
        f.setType(FieldTypeEnum.values()[fieldTypeListBox.getValue().intValue()]);
        f.setRequired(requiredYes.getValue());
        f.setDefaultValue(defaultValueWidget.getTextValue() != null ? defaultValueWidget.getTextValue().trim() : null);
        f.setOrder(orderTextBox.getText() != null && orderTextBox.getText().trim().length() > 0 ? Integer.valueOf(orderTextBox.getText()) : 1);
        f.setDropDown(dropDown != null ? dropDown.getValue() : false);
        f.setMaxChars(maxCharsTextBox != null && maxCharsTextBox.getText().trim().length() > 0 ? Integer.valueOf(maxCharsTextBox.getText()) : null);
        f.setMinChars(minCharsTextBox != null && minCharsTextBox.getText().trim().length() > 0 ? Integer.valueOf(minCharsTextBox.getText()) : null);
        if (hasDropDownTable) {
            if (customListPanel != null) {
                f.setKeyNames(customListPanel.getKeyNames());
            } else {
                f.setKeyNames(null);
            }
        }
        return f;
    }

    @Override
    public UiUserDefinedFieldRecord getRecord() {
        return record;
    }

    @Override
    public void revert() {

        updateWidgetsAccess();
    }

    @Override
    public String getStyleName() {
        return null;
    }

    @Override
    public Widget getWidget() {
        mainContainer.add( formContainer );
        return mainContainer;
    }

    @Override
    public void release() {
    }

    @Override
    public void saveFailed( Throwable throwable ) {
        if ( throwable instanceof ValidationException ) {
            ValidationException ve = (ValidationException) throwable;
            for ( String message : ve.getValidationMessages() ) {
                this.parentPanel.getErrorPanel().addMessage( message );
            }
        } else {
            this.parentPanel.getErrorPanel().showMessage( throwable.getLocalizedMessage() );
        }
    }

    @Override
    protected void onUnload() {
        super.onUnload();
    }
}
