package com.ericsson.cms.contractmgmt.client.tab.config;

import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.ConfigurationDataProvider.IBusyNotifier;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Table that shows the list of user defined fields.
 * 
 * @author Daniel Paranhos
 * 
 */
public class UserDefinedFieldListPanel extends Composite {

    private static final String TABLE_STYLE = "configuration-panel";
    private final String screenName;

    // table related
    private ConfigurationDataProvider dataProvider;
    private SortFeatureImpl<Long, UiUserDefinedFieldRecord> sortFeature;
    private UserDefinedFieldDetailFeature detailFeature;
    private BookmarkFeature bookmarkFeature;
    private AnchorChangeListener anchorChangeListener;

    // widgets used in this view
    private VerticalContainer mainContainer;
    private Table<Long, UiUserDefinedFieldRecord> table;
    private BusyIndicator busyIndicator = new BusyIndicator();

    // spacing between the table and message panel
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";

    private final SuccessPanel successPanel = new SuccessPanel();

    private final ErrorPanel errorPanel = new ErrorPanel();

    public UserDefinedFieldListPanel( String screenName ) {
        this.screenName = screenName;
        this.dataProvider = new ConfigurationDataProvider( screenName );
        dataProvider.setBusyNotifier( new IBusyNotifier() {
            @Override
            public void startingToBeBusy() {
                busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                busyIndicator.hide();
            }
        } );
        init();
    }

    private void init() {
        initWidgets();
        setContainers();
    }

    public SuccessPanel getSuccessPanel() {
        return successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return errorPanel;
    }

    private void setContainers() {
        mainContainer.add( successPanel );
        mainContainer.add( errorPanel );
        mainContainer.add( table );
    }

    private void initWidgets() {
        mainContainer = new VerticalContainer();
        mainContainer.setSpacing( SPACING );
        mainContainer.setStylePrimaryName( STYLE_NAME );
        this.initWidget( mainContainer );

        table = new Table<Long, UiUserDefinedFieldRecord>( dataProvider );
        table.setStyleName( TABLE_STYLE );

        // sort feature
        sortFeature = new SortFeatureImpl<Long, UiUserDefinedFieldRecord>(
                dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING );
        for ( Column<?, UiUserDefinedFieldRecord> col : dataProvider.getSortColumns() ) {
            sortFeature.addSortableColumn( col );
        }
        dataProvider.setParentSortFeature( sortFeature );

        // detail feature
        detailFeature = new UserDefinedFieldDetailFeature( this, this.screenName );

        // bookmark feature
        bookmarkFeature = new BookmarkFeatureImpl();

        table.addSortFeature( sortFeature );
        table.addDetailFeature( detailFeature );
        table.addBookmarkFeature( bookmarkFeature );

        table.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure( Throwable caught ) {
            }

            @Override
            public void onNeptuneSuccess( Void result ) {
            }
        } );

        anchorChangeListener = new ConfigurationAnchorChangeListener( this );
    }

    public Table<Long, UiUserDefinedFieldRecord> getUserDefinedFieldsTable() {
        return this.table;
    }

    public AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    /**
     * @param reverseAnchorChangeListener
     *            the reverseAnchorChangeListener to set
     */
    public void setReverseAnchorChangeListener( AnchorChangeListener reverseAnchorChangeListener ) {
        table.setAnchorChangeNotifier( reverseAnchorChangeListener );
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }
}
