package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;

public class ConfigurableFieldAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?recordId=1
    private static String RECORD_ID = "recordId";
    private static String PARAMETER_DELIMITER = "&";
    private static String VALUE_DELIMITER = "=";
    private final ConfigurableFieldListPanel widget;

    public ConfigurableFieldAnchorChangeListener( ConfigurableFieldListPanel listPanel ) {
        this.widget = listPanel;
    }

    @Override
    public void anchorChanged( String anchor ) {

        /* Check for anchor with title list id */
        if ( anchor != null && anchor.contains( RECORD_ID ) ) {
            widget.getTable().reset();

            // skip the first char
            anchor = anchor.substring( 1 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( RECORD_ID ) ) {
                    Long.parseLong( paramValue[1] );
                }
            }

        } else {
            widget.getTable().setAnchor( anchor );
        }
    }
}
