package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

/**
 * Data provider which operates on configurable fields.
 * 
 * @author Daniel Paranhos
 * 
 */
public abstract class ConfigurableFieldDataProvider implements DataProvider<Long, UiKeyNameRecord> {

    // columns for this table
    private final List<Column<?, UiKeyNameRecord>> columns;
    private final ColumnBase<String, UiKeyNameRecord> nameColumn;

    private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    protected List<UiKeyNameRecord> keyNameRecords;

    // column names
    private static String FIELD_NAME_COLUMN = "fieldName";

    // lists panel
    private IBusyNotifier busyNotifier;

    public ConfigurableFieldDataProvider() {
        this.keyNameRecords = new ArrayList<UiKeyNameRecord>();

        // create the columns - id and name
        columns = new ArrayList<Column<?, UiKeyNameRecord>>();

        nameColumn = new ColumnBase<String, UiKeyNameRecord>( FIELD_NAME_COLUMN,
                constants.configurationFieldNameColumn() ) {
            public View<String> getView( UiKeyNameRecord record ) {
                return new LabelStringView( record.getKeyName().getName() );
            }

        };
        nameColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( nameColumn );

    }

    public ColumnBase<String, UiKeyNameRecord> getDefaultSortColumn() {
        return nameColumn;
    }

    public List<Column<?, UiKeyNameRecord>> getSortColumns() {
        return columns;
    }

    @Override
    public List<Column<?, UiKeyNameRecord>> getColumns() {
        return columns;
    }

    @Override
    public void getRecord( Long key, final AsyncCallback<UiKeyNameRecord> callback ) {
        for ( UiKeyNameRecord record : keyNameRecords ) {
            if ( record.getKey().equals( key ) ) {
                callback.onSuccess( record );
                break;
            }
        }
    }

    @Override
    public void initialize( AsyncCallback<Void> callback ) {
        callback.onSuccess( null );
    }

    @Override
    public boolean isCheckboxEnabled() {
        return false;
    }

    @Override
    public boolean isRecordCountEnabled() {
        return false;
    }
    
    public static interface IBusyNotifier {
        void startingToBeBusy();

        void doneBeingBusy();
    }

    public void setBusyNotifier( IBusyNotifier busyNotifier ) {
        this.busyNotifier = busyNotifier;
    }

    protected void notifyBusyStart() {
        if ( busyNotifier != null ) {
            busyNotifier.startingToBeBusy();
        }
    }

    protected void notifyBusyFinish() {
        if ( busyNotifier != null ) {
            busyNotifier.doneBeingBusy();
        }
    }

}
