package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.contentprovider.ContentProviderMainDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency.CurrencyMainDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device.DeviceMainDetailView;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic.GenericMainDetailView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;

/**
 * Handles detail view for a given configurable field list.
 * 
 * @author Daniel Paranhos
 * 
 */
public class ConfigurableFieldDetailFeature extends AbstractDetailFeature<Long, UiKeyNameRecord> {

    private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    public ConfigurableFieldDetailFeature() {
        super( new UiLongKeySerializer() );
    }

    @Override
    public void getNew( AsyncCallback<UiKeyNameRecord> callback ) {
    }

    /*
     * The detail link is shown only if the user has asset view permissions and
     * the column is the name column.
     */
    @Override
    public boolean hasDetailLink( Column<?, UiKeyNameRecord> column ) {
        return column.getDisplayName().equals( constants.configurationFieldNameColumn() )
                && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_VIEW );
    }

    @Override
    public boolean showCreateButton() {
        return false;
    }

    @Override
    public boolean showDeleteButton() {
        return false;
    }

    @Override
    public DetailView<Long, UiKeyNameRecord> getView( UiKeyNameRecord record,
            DetailViewCallback<Long, UiKeyNameRecord> callback ) {
        
        DetailView<Long, UiKeyNameRecord> detailView = null;
        if ( record != null ) {
            ConfigurableFieldTypeEnum fieldType = ConfigurableFieldTypeEnum.values()[record.getKey().intValue()];
            
            if ( fieldType.isGeneric() ) {
                detailView = new GenericMainDetailView( fieldType, record, callback );
            } else if ( ConfigurableFieldTypeEnum.Device.equals( fieldType ) ) {
                detailView = new DeviceMainDetailView( record, callback );
            } else if ( ConfigurableFieldTypeEnum.Currency.equals( fieldType ) ) {
                detailView = new CurrencyMainDetailView( record, callback );
            } else if ( ConfigurableFieldTypeEnum.ContentProvider.equals( fieldType ) ) {
                detailView = new ContentProviderMainDetailView( record, callback );
            }
        }
        
        return detailView;
    }

    @Override
    public void save( UiKeyNameRecord record, AsyncCallback<Void> callback ) {
    }

    @Override
    public void delete( List<UiKeyNameRecord> records, AsyncCallback<Void> callback ) {
    }
}
