package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldDataProvider.IBusyNotifier;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Table that shows the list of configurable fields.
 * 
 * @author Daniel Paranhos
 * 
 */
public class ConfigurableFieldListPanel extends Composite {

    // table related
    private ConfigurableFieldDataProvider dataProvider;
    private ConfigurableFieldDetailFeature detailFeature;
    private AnchorChangeListener anchorChangeListener;

    // widgets used in this view
    private VerticalContainer mainContainer;
    private Table<Long, UiKeyNameRecord> table;
    private BusyIndicator busyIndicator = new BusyIndicator();

    // spacing between the table and message panel
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";
    private static final String TABLE_STYLE = "configuration-panel";

    public ConfigurableFieldListPanel( ConfigurableFieldDataProvider dataProvider ) {
        this.dataProvider = dataProvider;
        dataProvider.setBusyNotifier( new IBusyNotifier() {
            @Override
            public void startingToBeBusy() {
                busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                busyIndicator.hide();
            }
        } );
        init();
    }


    private void init() {
        initWidgets();
        setContainers();
    }

    private void setContainers() {
        mainContainer.add( table );
    }

    private void initWidgets() {
        mainContainer = new VerticalContainer();
        mainContainer.setSpacing( SPACING );
        mainContainer.setStylePrimaryName( STYLE_NAME );
        mainContainer.setWidth( "100%" );
        this.initWidget( mainContainer );


        table = new Table<Long, UiKeyNameRecord>( dataProvider );
        table.setStyleName( TABLE_STYLE );

        // detail feature
        detailFeature = new ConfigurableFieldDetailFeature();

        table.addDetailFeature( detailFeature );

        table.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure( Throwable caught ) {
            }

            @Override
            public void onNeptuneSuccess( Void result ) {
                table.refresh();
            }
        } );

        anchorChangeListener = new ConfigurableFieldAnchorChangeListener( this );
    }

    public Table<Long, UiKeyNameRecord> getTable() {
        return this.table;
    }

    public AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    /**
     * @param reverseAnchorChangeListener
     *            the reverseAnchorChangeListener to set
     */
    public void setReverseAnchorChangeListener( AnchorChangeListener reverseAnchorChangeListener ) {
        table.setAnchorChangeNotifier( reverseAnchorChangeListener );
    }

}
