package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

public enum ConfigurableFieldTypeEnum {

    ContractType("Contract Type", true, false, false), 
    DealType("Deal Type", true, false, false), 
    LicenseType("License Type", true, false, false), 
    Platform("Platform", true, true, true), 
    Device( "Device", false, true, true),
    DeliveryMethod("Delivery Method", true, false, false),
    MediaType("Media Type", true, false, false),
    Ownership("Ownership", true, false, false),
    MetaFormat("Meta Format", true, false, false),
    Currency("Currency", false, false, false),
    Frequency("Frequency", true, false, false),
    Language("Language", true, false, false),
    ContentProvider("Content Provider", false, false, false);

    private String displayName;
    private boolean isGeneric;
    private boolean hasPageFeature;
    private boolean hasSortFeature;

    private ConfigurableFieldTypeEnum( String displayName, boolean isGeneric, boolean hasPageFeature, boolean hasSortFeature ) {
        this.displayName = displayName;
        this.isGeneric = isGeneric;
        this.hasPageFeature = hasPageFeature;
        this.hasSortFeature = hasSortFeature;
    }

    /**
     * @return the displayName
     */
    public String getDisplayName() {
        return displayName;
    }

    /**
     * @return the generic
     */
    public boolean isGeneric() {
        return isGeneric;
    }

    /**
     * @return the hasPageFeature
     */
    public boolean hasPageFeature() {
        return hasPageFeature;
    }

    /**
     * @return the hasSortFeature
     */
    public boolean hasSortFeature() {
        return hasSortFeature;
    }

}
