package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * Data provider which operates on contract configurable fields.
 * 
 * @author Daniel Paranhos
 * 
 */
public class ContractConfigurableFieldDataProvider extends ConfigurableFieldDataProvider {

    @Override
    public void getRecords( AsyncCallback<List<UiKeyNameRecord>> callback ) {
        List<UiKeyNameRecord> records = new ArrayList<UiKeyNameRecord>();
        
        UiKeyName uiKeyName = new UiKeyName();
        uiKeyName.setKey( (long) ConfigurableFieldTypeEnum.ContractType.ordinal() );
        uiKeyName.setName( ConfigurableFieldTypeEnum.ContractType.getDisplayName() );
        
        records.add( new UiKeyNameRecord( uiKeyName ) );

        callback.onSuccess( records );
        
    }



}
