package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * Data provider which operates on distribution configurable fields.
 * 
 * @author Daniel Paranhos
 * 
 */
public class DistributionConfigurableFieldDataProvider extends ConfigurableFieldDataProvider {

    @Override
    public void getRecords( AsyncCallback<List<UiKeyNameRecord>> callback ) {
        List<UiKeyNameRecord> records = new ArrayList<UiKeyNameRecord>();
        
        UiKeyName uiKeyName = new UiKeyName();
        uiKeyName.setKey( (long) ConfigurableFieldTypeEnum.DeliveryMethod.ordinal() );
        uiKeyName.setName( ConfigurableFieldTypeEnum.DeliveryMethod.getDisplayName() );        
        records.add( new UiKeyNameRecord( uiKeyName ) );
        
        uiKeyName = new UiKeyName();
        uiKeyName.setKey( (long) ConfigurableFieldTypeEnum.MediaType.ordinal() );
        uiKeyName.setName( ConfigurableFieldTypeEnum.MediaType.getDisplayName() );        
        records.add( new UiKeyNameRecord( uiKeyName ) );
        
        uiKeyName = new UiKeyName();
        uiKeyName.setKey( (long) ConfigurableFieldTypeEnum.MetaFormat.ordinal() );
        uiKeyName.setName( ConfigurableFieldTypeEnum.MetaFormat.getDisplayName() );        
        records.add( new UiKeyNameRecord( uiKeyName ) );
        
        uiKeyName = new UiKeyName();
        uiKeyName.setKey( (long) ConfigurableFieldTypeEnum.Ownership.ordinal() );
        uiKeyName.setName( ConfigurableFieldTypeEnum.Ownership.getDisplayName() );        
        records.add( new UiKeyNameRecord( uiKeyName ) );


        callback.onSuccess( records );
        
    }



}
