package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * Data provider which operates on license configurable fields.
 * 
 * @author Daniel Paranhos
 * 
 */
public class LicenseConfigurableFieldDataProvider extends ConfigurableFieldDataProvider {

    @Override
    public void getRecords( AsyncCallback<List<UiKeyNameRecord>> callback ) {
        List<UiKeyNameRecord> records = new ArrayList<UiKeyNameRecord>();
        
        UiKeyName uiKeyName = new UiKeyName();
        uiKeyName.setKey( (long) ConfigurableFieldTypeEnum.LicenseType.ordinal() );
        uiKeyName.setName( ConfigurableFieldTypeEnum.LicenseType.getDisplayName() );
        records.add( new UiKeyNameRecord( uiKeyName ) );
        
        uiKeyName = new UiKeyName();
        uiKeyName.setKey( (long) ConfigurableFieldTypeEnum.Platform.ordinal() );
        uiKeyName.setName( ConfigurableFieldTypeEnum.Platform.getDisplayName() );
        records.add( new UiKeyNameRecord( uiKeyName ) );
        
        uiKeyName = new UiKeyName();
        uiKeyName.setKey( (long) ConfigurableFieldTypeEnum.Device.ordinal() );
        uiKeyName.setName( ConfigurableFieldTypeEnum.Device.getDisplayName() );
        records.add( new UiKeyNameRecord( uiKeyName ) );


        callback.onSuccess( records );
        
    }



}
