package com.ericsson.cms.contractmgmt.client.tab.config.configurablefield;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * Data provider which operates on storage and metadata configurable fields.
 * 
 * @author Daniel Paranhos
 * 
 */
public class StorageMetadataConfigurableFieldDataProvider extends ConfigurableFieldDataProvider {

    @Override
    public void getRecords( AsyncCallback<List<UiKeyNameRecord>> callback ) {
        List<UiKeyNameRecord> records = new ArrayList<UiKeyNameRecord>();
        
        UiKeyName uiKeyName = new UiKeyName();
        uiKeyName.setKey( (long) ConfigurableFieldTypeEnum.ContentProvider.ordinal() );
        uiKeyName.setName( ConfigurableFieldTypeEnum.ContentProvider.getDisplayName() );
        records.add( new UiKeyNameRecord( uiKeyName ) );
        
        uiKeyName = new UiKeyName();
        uiKeyName.setKey( (long) ConfigurableFieldTypeEnum.Language.ordinal() );
        uiKeyName.setName( ConfigurableFieldTypeEnum.Language.getDisplayName() );
        records.add( new UiKeyNameRecord( uiKeyName ) );

        callback.onSuccess( records );
        
    }



}
