package com.ericsson.cms.contractmgmt.client.tab.config.dropdown;

import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;

public class DropDownAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?recordId=1
    private static final String RECORD_ID = "recordId";
    private static final String PARAMETER_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    private final DropDownListPanel widget;

    public DropDownAnchorChangeListener( DropDownListPanel listPanel ) {
        this.widget = listPanel;
    }

    @Override
    public void anchorChanged( String anchor ) {

        /* Check for anchor with title list id */
        if ( anchor != null && anchor.contains( RECORD_ID ) ) {
            widget.getTable().reset();

            // skip the first char
            anchor = anchor.substring( 1 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( RECORD_ID ) ) {
                    Long.parseLong( paramValue[1] );
                }
            }

        } else {
            widget.getTable().setAnchor( anchor );
        }
    }
}
