package com.ericsson.cms.contractmgmt.client.tab.config.dropdown;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

/**
 * Data provider which operates on drop-down values.
 * 
 * @author Daniel Paranhos
 * 
 */
public abstract class DropDownDataProvider<Record extends UiKeyNameRecord> implements
        DataProvider<Long, Record> {

    // columns for this table
    protected final List<Column<?, Record>> columns;
    private final ColumnBase<String, Record> nameColumn;
    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, Record> parentSortFeature;

    protected ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    protected List<Record> records;

    // column names
    private static String NAME_COLUMN = "name";

    // lists panel
    private IBusyNotifier busyNotifier;

    public DropDownDataProvider() {
        this.records = new ArrayList<Record>();

        // create the columns - id and name
        columns = new ArrayList<Column<?, Record>>();

        nameColumn = new ColumnBase<String, Record>( NAME_COLUMN, constants.configurationDropDownNameColumn() ) {
            public View<String> getView( Record record ) {
                return new LabelStringView( record.getKeyName().getName() );
            }

        };
        nameColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( nameColumn );

    }

    public ColumnBase<String, Record> getDefaultSortColumn() {
        return nameColumn;
    }

    public List<Column<?, Record>> getSortColumns() {
        return columns;
    }

    @Override
    public List<Column<?, Record>> getColumns() {
        return columns;
    }

    @Override
    public void getRecord( Long key, final AsyncCallback<Record> callback ) {
        for ( Record record : records ) {
            if ( record.getKey().equals( key ) ) {
                callback.onSuccess( record );
                break;
            }
        }
    }

    @Override
    public void initialize( AsyncCallback<Void> callback ) {
        callback.onSuccess( null );
    }

    @Override
    public boolean isCheckboxEnabled() {
        return true;
    }

    @Override
    public boolean isRecordCountEnabled() {
        return true;
    }

    public static interface IBusyNotifier {
        void startingToBeBusy();

        void doneBeingBusy();
    }

    public void setBusyNotifier( IBusyNotifier busyNotifier ) {
        this.busyNotifier = busyNotifier;
    }

    protected void notifyBusyStart() {
        if ( busyNotifier != null ) {
            busyNotifier.startingToBeBusy();
        }
    }

    protected void notifyBusyFinish() {
        if ( busyNotifier != null ) {
            busyNotifier.doneBeingBusy();
        }
    }

    /**
     * @return the parentPageFeature
     */
    public PageFeature getParentPageFeature() {
        return parentPageFeature;
    }

    /**
     * @param parentPageFeature
     *            the parentPageFeature to set
     */
    public void setParentPageFeature( PageFeature parentPageFeature ) {
        this.parentPageFeature = parentPageFeature;
    }

    /**
     * @return the parentSortFeature
     */
    public SortFeatureImpl<Long, Record> getParentSortFeature() {
        return parentSortFeature;
    }

    /**
     * @param parentSortFeature
     *            the parentSortFeature to set
     */
    public void setParentSortFeature( SortFeatureImpl<Long, Record> parentSortFeature ) {
        this.parentSortFeature = parentSortFeature;
    }

}
