package com.ericsson.cms.contractmgmt.client.tab.config.dropdown;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;

/**
 * Handles detail view for a given drop down values list.
 * 
 * @author Daniel Paranhos
 * 
 */
public abstract class DropDownDetailFeature<Record extends UiKeyNameRecord> extends
        AbstractDetailFeature<Long, Record> {

    private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    public DropDownDetailFeature() {
        super( new UiLongKeySerializer() );
    }

    /*
     * The detail link is shown only if the user has asset view permissions and the column is the name column.
     */
    @Override
    public boolean hasDetailLink( Column<?, Record> column ) {
        return column.getDisplayName().equals( constants.contractNameColumn() )
                && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_VIEW );
    }

    @Override
    public boolean showCreateButton() {
        return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE );
    }

    @Override
    public boolean showDeleteButton() {
        return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_DELETE );
    }
}
