package com.ericsson.cms.contractmgmt.client.tab.config.dropdown;



import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;

import com.ericsson.cms.contractmgmt.client.Permissions;

import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;

import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;

import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;

import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;

import com.ericsson.cms.contractmgmt.client.tab.config.DefaultValueWidgetFactory;

import com.google.gwt.core.client.GWT;

import com.google.gwt.event.dom.client.ClickEvent;

import com.google.gwt.event.dom.client.ClickHandler;

import com.google.gwt.user.client.ui.Composite;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;

import com.google.gwt.user.client.ui.Widget;

import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;

import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;



public class DropDownDetailView extends Composite implements

DetailView<Long, UiKeyNameRecord> {



    private final UiKeyNameRecord record;

    private final DetailViewCallback<Long, UiKeyNameRecord> callback;

    private final VerticalContainer mainContainer;



    private final ErrorPanel errorPanel = new ErrorPanel();



    private final ContractComponentConstants constants = (ContractComponentConstants) GWT

            .create( ContractComponentConstants.class );



    private static final int MAX_LENGTH = 50;



    private final ContractFormContainer formContainer = new ContractFormContainer( HasHorizontalAlignment.ALIGN_LEFT );

    private DataTypeWidget<?> nameTextBox = null;

    private ButtonWidget saveButton;

    private final boolean parentModifying;

    private FieldTypeEnum fieldType = FieldTypeEnum.Text;

    private final DefaultValueWidgetFactory dvFactory = new DefaultValueWidgetFactory();



    public DropDownDetailView( final UiKeyNameRecord record,

            final DetailViewCallback<Long, UiKeyNameRecord> callback,

            boolean parentModifying, FieldTypeEnum type ) {

        this.record = record;

        this.callback = callback;

        this.parentModifying = parentModifying;

        if (type != null) {

            this.fieldType = type;

        }



        mainContainer = new VerticalContainer();



        initForm();

    }



    private void initForm() {

        nameTextBox = dvFactory.createTextField(record.getKeyName().getName(), false, MAX_LENGTH, fieldType);

        nameTextBox.ensureDebugId("license-"+fieldType.getType());



        formContainer.addRow( constants.configurationNameColumn(), nameTextBox, true );





        saveButton = new ButtonWidget( constants.saveButtonName(), new ClickHandler() {

            @Override

            public void onClick( ClickEvent event ) {

                errorPanel.reset();

                if ( formContainer.validate() ) {

                    callback.save( DropDownDetailView.this );

                }

            }



        } );

        saveButton.addStyleDependentName( StyleNames.COMMIT_BUTTON_STYLE );

        saveButton.ensureDebugId("configuration-save");

        formContainer.addButton( saveButton );



        ButtonWidget cancelButton = new ButtonWidget( constants.cancelButtonName(), new ClickHandler() {

            @Override

            public void onClick( ClickEvent event ) {

                errorPanel.reset();

                callback.cancel( DropDownDetailView.this );

            }

        } );

        cancelButton.addStyleDependentName( StyleNames.DATALOSS_BUTTON_STYLE );

        formContainer.addButton( cancelButton );

        updateWidgetsAccess();

    }





    private void updateWidgetsAccess() {

        boolean isCreating = record.getKey() == null;

        saveButton.setVisible( saveButtonIsVisible( isCreating ) );

    }



    private boolean saveButtonIsVisible( boolean isCreating ) {

        boolean visible = isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE )

                || !isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY )

                || parentModifying && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY );

        return visible;

    }



    @Override

    public void commit() {

        record.getKeyName().setName(nameTextBox.getTextValue().trim());

    }



    @Override

    public UiKeyNameRecord getRecord() {

        return record;

    }



    @Override

    public void revert() {



        updateWidgetsAccess();

    }



    @Override

    public String getStyleName() {

        return null;

    }



    @Override

    public Widget getWidget() {

        mainContainer.add( errorPanel );

        mainContainer.add( formContainer );

        return mainContainer;

    }



    @Override

    public void release() {

    }



    @Override

    public void saveFailed( Throwable throwable ) {

        if ( throwable instanceof ValidationException ) {

            ValidationException ve = (ValidationException) throwable;

            for ( String message : ve.getValidationMessages() ) {

                errorPanel.addMessage(message);

            }

        } else {

            errorPanel.showMessage( throwable.getLocalizedMessage() );

        }

    }



    @Override

    protected void onUnload() {

        super.onUnload();

    }

}

