package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.contentprovider;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiContentProvider;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * Data provider which operates on content providers.
 * 
 * @author Daniel Paranhos
 * 
 */
public class ContentProviderDataProvider extends DropDownDataProvider<UiContentProviderRecord> {
    
    private IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT.create( IContractManagerDropDownService.class );
    
    public ContentProviderDataProvider() {
        super();
    }

    @Override
    public void getRecords( final AsyncCallback<List<UiContentProviderRecord>> callback ) {
        notifyBusyStart();
        contractManagerDropDownService.getContentProvidersList( new NeptuneAsyncCallback<List<UiContentProvider>>() {

            @Override
            public void onNeptuneFailure( Throwable caught ) {
                notifyBusyFinish();
                callback.onFailure( caught );
            }

            @Override
            public void onNeptuneSuccess( List<UiContentProvider> result ) {
                records.clear();
                for ( UiContentProvider uiContentProvider : result ) {
                    records.add( new UiContentProviderRecord( uiContentProvider ) );
                }
                notifyBusyFinish();
                callback.onSuccess( records );                
            }

        } );
    }

    @Override
    public boolean isCheckboxEnabled() {
        return false;
    }
}
