package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.contentprovider;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiContentProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;

/**
 * Handles detail view for a given content provider.
 * 
 * @author Daniel Paranhos
 * 
 */
public class ContentProviderDetailFeature extends DropDownDetailFeature<UiContentProviderRecord> {

    private ContentProviderListPanel parentPanel;

    public ContentProviderDetailFeature(ContentProviderListPanel parentPanel) {
        super();
        this.parentPanel = parentPanel;
    }

    @Override
    public void delete( List<UiContentProviderRecord> records, final AsyncCallback<Void> callback ) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getNew( AsyncCallback<UiContentProviderRecord> callback ) {
        this.parentPanel.clearMessages();
        callback.onSuccess( new UiContentProviderRecord( new UiContentProvider() ) );
    }

    @Override
    public DetailView<Long, UiContentProviderRecord> getView( UiContentProviderRecord record,
            DetailViewCallback<Long, UiContentProviderRecord> callback ) {
        this.parentPanel.clearMessages();
        ContentProviderDetailView view = new ContentProviderDetailView( record, callback );
        return view;
    }


    @Override
    public void save( UiContentProviderRecord record, final AsyncCallback<Void> callback ) {
        throw new UnsupportedOperationException();
    }
    
    @Override
    public boolean showCreateButton() {
        return false;
    }

    @Override
    public boolean showDeleteButton() {
        return false;
    }

    @Override
    public boolean hasDetailLink(Column<?, UiContentProviderRecord> column) {
        return false;
    }
    
}
