package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.contentprovider;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class ContentProviderDetailView extends Composite implements DetailView<Long, UiContentProviderRecord> {

    private static final String STYLE_VALIDATION_MESSAGE = "contract-failure-message";

    private UiContentProviderRecord record;
    private DetailViewCallback<Long, UiContentProviderRecord> callback;
    private VerticalContainer mainContainer;

    private final LabelWidget errorMessageLabel = new LabelWidget();

    private final ContractFormContainer formContainer = new ContractFormContainer(
            HasHorizontalAlignment.ALIGN_LEFT );
    private TextBoxWidget nameTextBox = new TextBoxWidget();

    private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    public ContentProviderDetailView( final UiContentProviderRecord record,
            final DetailViewCallback<Long, UiContentProviderRecord> callback ) {
        this.record = record;
        this.callback = callback;

        mainContainer = new VerticalContainer();
        errorMessageLabel.setStyleName( STYLE_VALIDATION_MESSAGE );

        initForm();
    }

    private void initForm() {

        nameTextBox.setText( record.getContentProvider().getName() );
        formContainer.addRow( constants.configurationNameColumn(), nameTextBox, true );

        ButtonWidget cancelButton = new ButtonWidget( constants.cancelButtonName(), new ClickHandler() {
            public void onClick( ClickEvent event ) {
                errorMessageLabel.setText( null );
                callback.cancel( ContentProviderDetailView.this );
            }
        } );
        cancelButton.addStyleDependentName( StyleNames.DATALOSS_BUTTON_STYLE );
        formContainer.addButton( cancelButton );
    }

    @Override
    public void commit() {
        record.getContentProvider().setName( nameTextBox.getText() );
    }

    @Override
    public UiContentProviderRecord getRecord() {
        return record;
    }

    @Override
    public void revert() {
        nameTextBox.setText( record.getContentProvider().getName() );
    }

    @Override
    public String getStyleName() {
        return null;
    }

    @Override
    public Widget getWidget() {
        mainContainer.add( errorMessageLabel );
        mainContainer.add( formContainer );
        return mainContainer;
    }

    @Override
    public void release() {
    }

    @Override
    public void saveFailed( Throwable throwable ) {
    }

    @Override
    protected void onUnload() {
        super.onUnload();
    }
}
