package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.contentprovider;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownListPanel;

/**
 * Table that shows the list of content providers.
 * 
 * @author Daniel Paranhos
 * 
 */
public class ContentProviderListPanel extends DropDownListPanel<UiContentProviderRecord> {

    public ContentProviderListPanel() {
        super( false, false );
    }

    @Override
    protected DropDownDetailFeature<UiContentProviderRecord> getDropDownDetailFeature() {
        return new ContentProviderDetailFeature(this);
    }

    @Override
    protected DropDownDataProvider<UiContentProviderRecord> getDataProvider() {
        return new ContentProviderDataProvider();
    }

    public String getCreateHeading() {
        return ConfigurableFieldTypeEnum.ContentProvider.getDisplayName() + " " + constants.genericDetailsHeading();
    }

    public String getEditHeading() {
        return ConfigurableFieldTypeEnum.ContentProvider.getDisplayName() + " " + constants.genericDetailsHeading();
    }

    public String getListHeading() {
        return ConfigurableFieldTypeEnum.ContentProvider.getDisplayName() + " " + constants.genericListHeading();
    }

}
