package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.contentprovider;

import com.ericsson.cms.contractmgmt.client.model.UiContentProvider;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;

/**
 * Represents a content provider record in the content provider list view.
 * 
 * @author Daniel Paranhos
 * 
 */
public class UiContentProviderRecord extends UiKeyNameRecord {

    private UiContentProvider uiContentProvider;

    public UiContentProviderRecord() {
        this.setKeyName( new UiKeyName() );
        this.uiContentProvider = new UiContentProvider();
    }

    public UiContentProviderRecord( UiContentProvider uiContentProvider ) {
        this.uiContentProvider = uiContentProvider;
        UiKeyName keyName = new UiKeyName();
        keyName.setName( uiContentProvider.getName() );
        this.setKeyName( keyName );
    }

    @Override
    public Long getKey() {
        return getKeyName().getKey();
    }
    
    /**
     * @param keyName
     *            the keyName to set
     */
    @Override
    public void setKeyName( UiKeyName keyName ) {
        super.setKeyName( keyName );
        uiContentProvider.setName( keyName.getName() );
    }

    /**
     * @return the content provider
     */
    public UiContentProvider getContentProvider() {
        return uiContentProvider;
    }

    /**
     * @param uiContentProvider
     *            the content provider to set
     */
    public void setContentProvider( UiContentProvider uiContentProvider ) {
        this.uiContentProvider = uiContentProvider;
    }

}
