package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

/**
 * Data provider which operates on currencies.
 * 
 * @author Daniel Paranhos
 * 
 */
public class CurrencyDataProvider extends DropDownDataProvider<UiCurrencyRecord> {
    
    private IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT.create( IContractManagerDropDownService.class );
    
    // additional columns for this table
    private final ColumnBase<String, UiCurrencyRecord> symbolColumn;
    
    // addtional column names
    private static String SYMBOL_COLUMN = "symbol";

    public CurrencyDataProvider() {
        super();

        symbolColumn = new ColumnBase<String, UiCurrencyRecord>( SYMBOL_COLUMN,
                constants.currencySymbolColumn() ) {
            public View<String> getView( UiCurrencyRecord record ) {
                return new LabelStringView( record.getCurrency().getSymbol() );
            }

        };
        symbolColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( symbolColumn );
    }

    @Override
    public void getRecords( final AsyncCallback<List<UiCurrencyRecord>> callback ) {
        notifyBusyStart();
        contractManagerDropDownService.getCurrencies( new NeptuneAsyncCallback<List<UiCurrency>>() {

            @Override
            public void onNeptuneFailure( Throwable caught ) {
                notifyBusyFinish();
                callback.onFailure( caught );
            }

            @Override
            public void onNeptuneSuccess( List<UiCurrency> result ) {
                records.clear();
                for ( UiCurrency currency : result ) {
                    records.add( new UiCurrencyRecord( currency ) );
                }
                notifyBusyFinish();
                callback.onSuccess( records );                
            }

        } );
    }


}
