package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;

/**
 * Handles detail view for a given currency.
 * 
 * @author Daniel Paranhos
 * 
 */
public class CurrencyDetailFeature extends DropDownDetailFeature<UiCurrencyRecord> {

    private IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT
            .create(IContractManagerDropDownService.class);
    private ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create(ContractComponentMessages.class);
    private CurrencyListPanel parentPanel;

    public CurrencyDetailFeature(CurrencyListPanel parentPanel) {
        super();
        this.parentPanel = parentPanel;
    }

    @Override
    public void delete( List<UiCurrencyRecord> records, final AsyncCallback<Void> callback ) {
        if (records.size() > 0) {
            if (Window.confirm(messages.deleteGenericConfirmation() + " " + ConfigurableFieldTypeEnum.Currency.getDisplayName())) {
                List<UiCurrency> currencies = new ArrayList<UiCurrency>();
                for (UiCurrencyRecord record : records) {
                    currencies.add(record.getCurrency());
                }
                contractManagerDropDownService.deleteCurrencies(currencies,
                        new NeptuneAsyncCallback<Void>() {

                            @Override
                            public void onNeptuneFailure(Throwable caught) {
                                parentPanel.getTable().refresh();
                                parentPanel.getErrorPanel().showMessage(messages.deleteGenericError() + " "
                                        + ConfigurableFieldTypeEnum.Currency.getDisplayName());
                                if (caught instanceof ValidationException ) {
                                    ValidationException ve = (ValidationException) caught;
                                    for ( String message : ve.getValidationMessages() ) {
                                        parentPanel.getErrorPanel().addMessage(message);
                                    }
                                } else {
                                    callback.onFailure(caught);
                                }
                            }

                            @Override
                            public void onNeptuneSuccess(Void result) {
                                parentPanel.getSuccessPanel().showMessage(ConfigurableFieldTypeEnum.Currency.getDisplayName() + " "
                                        + messages.deleteGenericSucceeded());
                                callback.onSuccess(null);
                            }
                        });
            }
        } else {
            Window.alert(messages.noGenericSelected() + " " + ConfigurableFieldTypeEnum.Currency.getDisplayName());
        }
    }

    @Override
    public void getNew( AsyncCallback<UiCurrencyRecord> callback ) {
        this.parentPanel.clearMessages();
        callback.onSuccess( new UiCurrencyRecord( new UiCurrency() ) );
    }

    @Override
    public DetailView<Long, UiCurrencyRecord> getView( UiCurrencyRecord record,
            DetailViewCallback<Long, UiCurrencyRecord> callback ) {
        this.parentPanel.clearMessages();
        CurrencyDetailView view = new CurrencyDetailView( this.parentPanel, record, callback );
        return view;
    }


    @Override
    public void save( UiCurrencyRecord record, final AsyncCallback<Void> callback ) {
        contractManagerDropDownService.saveCurrency(record.getCurrency(),
                new NeptuneAsyncCallback<Void>() {

                    @Override
                    public void onNeptuneFailure(Throwable caught) {
                        parentPanel.getErrorPanel().showMessage(messages.saveGenericError() + " "
                                + ConfigurableFieldTypeEnum.Currency.getDisplayName());
                        callback.onFailure(caught);
                    }

                    @Override
                    public void onNeptuneSuccess(Void result) {
                        parentPanel.getSuccessPanel().showMessage(ConfigurableFieldTypeEnum.Currency.getDisplayName() + " "
                                + messages.saveGenericSucceeded());
                        callback.onSuccess(null);
                    }
                });
    }

    @Override
    public boolean showCreateButton() {
        if (this.parentPanel.isModifying()) {
            return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY );
        } else {
            return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE );
        }
    }

    @Override
    public boolean showDeleteButton() {
        if (this.parentPanel.isModifying()) {
            return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY );
        } else {
            return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_DELETE );
        }
    }
}
