package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class CurrencyDetailView extends Composite implements DetailView<Long, UiCurrencyRecord> {

    private final UiCurrencyRecord record;
    private final DetailViewCallback<Long, UiCurrencyRecord> callback;
    private final VerticalContainer mainContainer;

    private static final int MAX_LENGTH = 50;

    private final ContractFormContainer formContainer = new ContractFormContainer(
            HasHorizontalAlignment.ALIGN_LEFT );
    private final TextBoxWidget nameTextBox = new TextBoxWidget();
    private final TextBoxWidget symbolTextBox = new TextBoxWidget();
    private ButtonWidget saveButton;

    private final ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );
    private final CurrencyListPanel parentPanel;

    public CurrencyDetailView( CurrencyListPanel parentPanel, final UiCurrencyRecord record,
            final DetailViewCallback<Long, UiCurrencyRecord> callback ) {
        this.record = record;
        this.callback = callback;
        this.parentPanel = parentPanel;

        mainContainer = new VerticalContainer();

        initForm();
        updateWidgetsAccess();
    }

    private void initForm() {

        nameTextBox.setMaxLength(MAX_LENGTH);
        nameTextBox.setText( record.getKeyName().getName() );
        formContainer.addRow( constants.configurationNameColumn(), nameTextBox, true );

        symbolTextBox.setMaxLength(MAX_LENGTH);
        symbolTextBox.setText( record.getCurrency().getSymbol() );
        formContainer.addRow( constants.currencySymbolColumn(), symbolTextBox, true );

        saveButton = new ButtonWidget( constants.saveButtonName(), new ClickHandler() {
            @Override
            public void onClick( ClickEvent event ) {
                parentPanel.clearMessages();
                if ( formContainer.validate() ) {
                    callback.save( CurrencyDetailView.this );
                }
            }

        } );
        saveButton.addStyleDependentName( StyleNames.COMMIT_BUTTON_STYLE );
        formContainer.addButton( saveButton );

        ButtonWidget cancelButton = new ButtonWidget( constants.cancelButtonName(), new ClickHandler() {
            @Override
            public void onClick( ClickEvent event ) {
                parentPanel.clearMessages();
                callback.cancel( CurrencyDetailView.this );
            }
        } );
        cancelButton.addStyleDependentName( StyleNames.DATALOSS_BUTTON_STYLE );
        formContainer.addButton( cancelButton );
    }

    private void updateWidgetsAccess() {
        boolean isCreating = record.getKey() == null;
        saveButton.setVisible( saveButtonIsVisible( isCreating ) );
    }

    private boolean saveButtonIsVisible( boolean isCreating ) {
        boolean visible = isCreating && ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_CREATE)
                    || !isCreating && ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_MODIFY)
                    || this.parentPanel.isModifying() && ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_MODIFY);
        return visible;
    }

    @Override
    public void commit() {
        record.getCurrency().setName( nameTextBox.getText().trim() );
        record.getCurrency().setSymbol( symbolTextBox.getText().trim() );
    }

    @Override
    public UiCurrencyRecord getRecord() {
        return record;
    }

    @Override
    public void revert() {
        nameTextBox.setText( record.getCurrency().getName() );
        symbolTextBox.setText( record.getCurrency().getSymbol() );

        updateWidgetsAccess();
    }

    @Override
    public String getStyleName() {
        return null;
    }

    @Override
    public Widget getWidget() {
        mainContainer.add( formContainer );
        return mainContainer;
    }

    @Override
    public void release() {
    }

    @Override
    public void saveFailed( Throwable throwable ) {
        if ( throwable instanceof ValidationException ) {
            ValidationException ve = (ValidationException) throwable;
            for ( String message : ve.getValidationMessages() ) {
                this.parentPanel.getErrorPanel().addMessage( message );
            }
        } else {
            this.parentPanel.getErrorPanel().showMessage( throwable.getLocalizedMessage() );
        }
    }

    @Override
    protected void onUnload() {
        super.onUnload();
    }
}
