package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency;

import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownListPanel;

/**
 * Table that shows the list of currencies.
 * 
 * @author Daniel Paranhos
 * 
 */
public class CurrencyListPanel extends DropDownListPanel<UiCurrencyRecord> {

    private boolean isModifying = false;

    public CurrencyListPanel(boolean isModifying) {
        super( false, false );
        this.isModifying = isModifying;
    }

    @Override
    protected DropDownDetailFeature<UiCurrencyRecord> getDropDownDetailFeature() {
        return new CurrencyDetailFeature(this);
    }

    @Override
    protected DropDownDataProvider<UiCurrencyRecord> getDataProvider() {
        return new CurrencyDataProvider();
    }

    public String getCreateHeading() {
        return ConfigurableFieldTypeEnum.Currency.getDisplayName() + " " + constants.genericDetailsHeading();
    }

    public String getEditHeading() {
        return ConfigurableFieldTypeEnum.Currency.getDisplayName() + " " + constants.genericDetailsHeading();
    }

    public String getListHeading() {
        return ConfigurableFieldTypeEnum.Currency.getDisplayName() + " " + constants.genericListHeading();
    }

    /**
     * @return the isModifying
     */
    public boolean isModifying() {
        return isModifying;
    }

}
