package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.currency;

import com.ericsson.cms.contractmgmt.client.model.UiCurrency;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;

/**
 * Represents a currency record in the currency list view.
 * 
 * @author Daniel Paranhos
 * 
 */
public class UiCurrencyRecord extends UiKeyNameRecord {

    private UiCurrency currency;

    public UiCurrencyRecord() {
        this.setKeyName( new UiKeyName() );
        this.currency = new UiCurrency();
    }

    public UiCurrencyRecord( UiCurrency currency ) {
        this.currency = currency;
        UiKeyName keyName = new UiKeyName();
        keyName.setKey( currency.getKey() );
        keyName.setName( currency.getName() );
        this.setKeyName( keyName );
    }

    @Override
    public Long getKey() {
        return getKeyName().getKey();
    }
    
    /**
     * @param keyName
     *            the keyName to set
     */
    @Override
    public void setKeyName( UiKeyName keyName ) {
        super.setKeyName( keyName );
        currency.setKey( keyName.getKey() );
        currency.setName( keyName.getName() );
    }

    /**
     * @return the currency
     */
    public UiCurrency getCurrency() {
        return currency;
    }

    /**
     * @param currency
     *            the currency to set
     */
    public void setCurrency( UiCurrency currency ) {
        this.currency = currency;
    }

}
