package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.custom;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * Data provider which operates on custom drop-down values.
 * 
 * @author Daniel Paranhos
 * 
 */
public class CustomDataProvider extends DropDownDataProvider<UiKeyNameRecord> {
    
    private IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT.create( IContractManagerDropDownService.class );
    
    private Long userDefinedFieldId;
    
    private CustomListPanel parentPanel;
    
    public CustomDataProvider( Long userDefinedFieldId, CustomListPanel parentPanel ) {
        super();
        this.userDefinedFieldId = userDefinedFieldId;
        this.parentPanel = parentPanel;
    }

    @Override
    public void getRecords( final AsyncCallback<List<UiKeyNameRecord>> callback ) {
        if (parentPanel.isEditing()) {
            notifyBusyStart();
            contractManagerDropDownService.getDropDownKeyNameList( userDefinedFieldId, new NeptuneAsyncCallback<List<UiKeyName>>() {
    
                @Override
                public void onNeptuneFailure( Throwable caught ) {
                    callback.onFailure( caught );
                    notifyBusyFinish();
                }
    
                @Override
                public void onNeptuneSuccess( List<UiKeyName> result ) {
                    records.clear();
                    for ( UiKeyName uiKeyName : result ) {
                        records.add( new UiKeyNameRecord( uiKeyName ) );
                    }
                    callback.onSuccess( records );
                    notifyBusyFinish();
                }
    
            } );
        } else {
            records.clear();
            for (UiKeyName uiKeyName : parentPanel.getKeyNames()) {
                records.add(new UiKeyNameRecord(uiKeyName));
            }
            callback.onSuccess(records);
        }
    }


}
