package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.custom;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;

/**
 * Handles detail view for a given a custom drop-down
 * 
 * @author Daniel Paranhos
 * 
 */
public class CustomDetailFeature extends DropDownDetailFeature<UiKeyNameRecord> {

    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT.create( IContractManagerDropDownService.class );
    private final ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create(ContractComponentMessages.class);

    private final CustomListPanel parentPanel;
    private final Long userDefinedFieldId;
    private boolean isCreating = false;
    private FieldTypeEnum type = FieldTypeEnum.Text;

    public CustomDetailFeature(Long userDefinedFieldId, CustomListPanel parentPanel, FieldTypeEnum type) {
        super();
        this.parentPanel = parentPanel;
        this.userDefinedFieldId = userDefinedFieldId;
        isCreating = userDefinedFieldId == null;
        if (type != null) {
        	this.type = type;
        }
    }

    @Override
    public void delete(List<UiKeyNameRecord> records,
            final AsyncCallback<Void> callback) {
        if (records.size() > 0) {
            if (parentPanel.isEditing()) {
                if (Window.confirm(messages.deleteDropDownConfirmation())) {
                    List<UiKeyName> keyNames = new ArrayList<UiKeyName>();
                    for (UiKeyNameRecord record : records) {
                        keyNames.add(record.getKeyName());
                    }
                    parentPanel.clearMessages();
                    contractManagerDropDownService.deleteCustomDropDownKeyNames(keyNames,
                                    new NeptuneAsyncCallback<Void>() {

                                        @Override
                                        public void onNeptuneFailure(Throwable caught) {
                                            parentPanel.getErrorPanel().showMessage(messages.deleteDropDownError());
                                            if (caught instanceof ValidationException ) {
                                                ValidationException ve = (ValidationException) caught;
                                                for ( String message : ve.getValidationMessages() ) {
                                                    parentPanel.getErrorPanel().addMessage(message);
                                                }
                                            } else {
                                                callback.onFailure(caught);
                                            }
                                        }

                                        @Override
                                        public void onNeptuneSuccess(Void result) {
                                            parentPanel.getSuccessPanel().showMessage(messages.deleteDropDownSucceeded());
                                            callback.onSuccess(null);
                                        }
                                    });
                }

            } else {
                for (UiKeyNameRecord record : records) {
                    parentPanel.getKeyNames().remove(record.getKeyName());
                }
                callback.onSuccess(null);
            }
        } else {
            Window.alert(messages.noDropDownSelected());
        }
    }

    @Override
    public void getNew( AsyncCallback<UiKeyNameRecord> callback ) {
        this.parentPanel.clearMessages();
        callback.onSuccess( new UiKeyNameRecord( new UiKeyName() ) );
    }

    @Override
    public DetailView<Long, UiKeyNameRecord> getView( UiKeyNameRecord record,
            DetailViewCallback<Long, UiKeyNameRecord> callback ) {
        this.parentPanel.clearMessages();
        DropDownDetailView view = new DropDownDetailView( record, callback, !isCreating, type );
        return view;
    }


    @Override
    public void save( UiKeyNameRecord record, final AsyncCallback<Void> callback ) {
        if (parentPanel.isEditing()) {
            parentPanel.clearMessages();
            contractManagerDropDownService.saveCustomDropDownKeyName(
                    record.getKeyName(), this.userDefinedFieldId,
                    new NeptuneAsyncCallback<Void>() {

                        @Override
                        public void onNeptuneFailure(Throwable caught) {
                            parentPanel.getTable().refresh();
                            callback.onFailure(caught);
                        }

                        @Override
                        public void onNeptuneSuccess(Void result) {
                            parentPanel.getSuccessPanel().showMessage(messages.saveDropDownSucceeded());
                            callback.onSuccess(null);
                        }
            });
        } else {
            boolean exists = false;
            for (UiKeyName keyName : parentPanel.getKeyNames()) {
                if (record.getKeyName().getName().equals(keyName.getName())) {
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                parentPanel.getKeyNames().add(record.getKeyName());
            }
            callback.onSuccess(null);
        }
    }

    @Override
    public boolean showCreateButton() {
        return isCreating && ClientAuthorizationManager
                .isAuthorized(Permissions.CONTRACT_CREATE)
                || !isCreating && ClientAuthorizationManager
                        .isAuthorized(Permissions.CONTRACT_MODIFY);
    }

    @Override
    public boolean showDeleteButton() {
        return isCreating && ClientAuthorizationManager
                .isAuthorized(Permissions.CONTRACT_CREATE)
                || !isCreating && ClientAuthorizationManager
                        .isAuthorized(Permissions.CONTRACT_MODIFY);
    }
}