package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.custom;

import java.util.HashSet;
import java.util.Set;

import com.ericsson.cms.contractmgmt.client.customfield.FieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownListPanel;


/**
 * Table that shows the list of custom drop-down values.
 * 
 * @author Daniel Paranhos
 * 
 */
public class CustomListPanel extends DropDownListPanel<UiKeyNameRecord> {
    
    private Set<UiKeyName> keyNames = new HashSet<UiKeyName>();
    
    public CustomListPanel( Long userDefinedFieldId, FieldTypeEnum type ) {
        super( false, false, userDefinedFieldId, type );
    }
    
    @Override
    protected DropDownDetailFeature<UiKeyNameRecord> getDropDownDetailFeature() {
        return new CustomDetailFeature(userDefinedFieldId, this, type);
    }

    @Override
    protected DropDownDataProvider<UiKeyNameRecord> getDataProvider() {
        return new CustomDataProvider( userDefinedFieldId, this );
    }

    /**
     * @param keyNames the keyNames to set
     */
    public void setKeyNames(Set<UiKeyName> keyNames) {
        this.keyNames = keyNames;
    }

    /**
     * @return the keyNames
     */
    public Set<UiKeyName> getKeyNames() {
        return keyNames;
    }
    
}
