package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiDevices;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

/**
 * Data provider which operates on devices.
 * 
 * @author Daniel Paranhos
 * 
 */
public class DeviceDataProvider extends DropDownDataProvider<UiDeviceRecord> {

    private IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT.create( IContractManagerDropDownService.class );

    // additional columns for this table
    private final ColumnBase<String, UiDeviceRecord> platformColumn;

    // addtional column names
    private static String PLATFORM_COLUMN = "platform";

    public DeviceDataProvider() {
        super();

        platformColumn = new ColumnBase<String, UiDeviceRecord>( PLATFORM_COLUMN,
                constants.configurationPlatformColumn() ) {
            public View<String> getView( UiDeviceRecord record ) {
                return new LabelStringView( record.getDevice().getPlatform().getName() );
            }

        };
        platformColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( platformColumn );
    }

    @Override
    public void getRecords( final AsyncCallback<List<UiDeviceRecord>> callback ) {
        notifyBusyStart();
        int length = getParentPageFeature().getPageSize();
        int start = ( getParentPageFeature().getPageNumber() - 1 ) * length;

        contractManagerDropDownService.getDevices( start, length, getParentSortFeature().getSortColumnName(),
                getParentSortFeature().isAscending(), new NeptuneAsyncCallback<UiDevices>() {

                    @Override
                    public void onNeptuneFailure( Throwable caught ) {
                        getParentPageFeature().setRecordCount(-1);
                        notifyBusyFinish();
                        callback.onFailure( caught );
                    }

                    @Override
                    public void onNeptuneSuccess( UiDevices result ) {
                        getParentPageFeature().setRecordCount( result.getTotalCount() );
                        records.clear();
                        for ( UiDevice device : result.getDevices() ) {
                            records.add( new UiDeviceRecord( device ) );
                        }
                        notifyBusyFinish();
                        callback.onSuccess( records );
                    }

                } );
    }

}
