package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;

/**
 * Handles detail view for a given deal type.
 * 
 * @author Daniel Paranhos
 * 
 */
public class DeviceDetailFeature extends DropDownDetailFeature<UiDeviceRecord> {

    private IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT
            .create(IContractManagerDropDownService.class);
    private ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create(ContractComponentMessages.class);
    private DeviceListPanel parentPanel;

    public DeviceDetailFeature(DeviceListPanel parentPanel) {
        super();
        this.parentPanel = parentPanel;
    }

    @Override
    public void delete( List<UiDeviceRecord> records, final AsyncCallback<Void> callback ) {
        if (records.size() > 0) {
            if (Window.confirm(messages.deleteGenericConfirmation() + " " + ConfigurableFieldTypeEnum.Device.getDisplayName())) {
                List<UiDevice> devices = new ArrayList<UiDevice>();
                for (UiDeviceRecord record : records) {
                    devices.add(record.getDevice());
                }
                contractManagerDropDownService.deleteDevices(devices,
                        new NeptuneAsyncCallback<Void>() {

                            @Override
                            public void onNeptuneFailure(Throwable caught) {
                                parentPanel.getTable().refresh();
                                parentPanel.getErrorPanel().showMessage(messages.deleteGenericError() + " "
                                        + ConfigurableFieldTypeEnum.Device.getDisplayName());
                                if (caught instanceof ValidationException ) {
                                    ValidationException ve = (ValidationException) caught;
                                    for ( String message : ve.getValidationMessages() ) {
                                        parentPanel.getErrorPanel().addMessage(message);
                                    }
                                } else {
                                    callback.onFailure(caught);
                                }
                            }

                            @Override
                            public void onNeptuneSuccess(Void result) {
                                parentPanel.getSuccessPanel().showMessage(ConfigurableFieldTypeEnum.Device.getDisplayName() + " "
                                        + messages.deleteGenericSucceeded());
                                callback.onSuccess(null);
                            }
                        });
            }
        } else {
            Window.alert(messages.noGenericSelected() + " " + ConfigurableFieldTypeEnum.Device.getDisplayName());
        }
    }

    @Override
    public void getNew( AsyncCallback<UiDeviceRecord> callback ) {
        this.parentPanel.clearMessages();
        callback.onSuccess( new UiDeviceRecord( new UiDevice() ) );
    }

    @Override
    public DetailView<Long, UiDeviceRecord> getView( UiDeviceRecord record,
            DetailViewCallback<Long, UiDeviceRecord> callback ) {
        this.parentPanel.clearMessages();
        DeviceDetailView view = new DeviceDetailView( this.parentPanel, record, callback );
        return view;
    }


    @Override
    public void save( UiDeviceRecord record, final AsyncCallback<Void> callback ) {
        contractManagerDropDownService.saveDevice(record.getDevice(),
                new NeptuneAsyncCallback<Void>() {

                    @Override
                    public void onNeptuneFailure(Throwable caught) {
                        parentPanel.getErrorPanel().showMessage(messages.saveGenericError() + " "
                                + ConfigurableFieldTypeEnum.Device.getDisplayName());
                        callback.onFailure(caught);
                    }

                    @Override
                    public void onNeptuneSuccess(Void result) {
                        parentPanel.getSuccessPanel().showMessage(ConfigurableFieldTypeEnum.Device.getDisplayName() + " "
                                + messages.saveGenericSucceeded());
                        callback.onSuccess(null);
                    }
                });
    }

}
