package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device;

import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.model.UiPlatform;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class DeviceDetailView extends Composite implements DetailView<Long, UiDeviceRecord> {

    private UiDeviceRecord record;
    private DetailViewCallback<Long, UiDeviceRecord> callback;
    private VerticalContainer mainContainer;

    private static final int MAX_LENGTH = 50;

    private final ContractFormContainer formContainer = new ContractFormContainer(
            HasHorizontalAlignment.ALIGN_LEFT );
    private TextBoxWidget nameTextBox = new TextBoxWidget();
    private TypedListBoxWidget<Long> platformListBox;
    private ButtonWidget saveButton;

    private IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT.create( IContractManagerDropDownService.class );

    private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );
    private DeviceListPanel parentPanel;

    public DeviceDetailView( DeviceListPanel parentPanel, final UiDeviceRecord record,
            final DetailViewCallback<Long, UiDeviceRecord> callback ) {
        this.record = record;
        this.callback = callback;
        this.parentPanel = parentPanel;

        mainContainer = new VerticalContainer();

        initForm();
        updateWidgetsAccess();
    }

    private void initForm() {

        nameTextBox.setMaxLength(MAX_LENGTH);
        nameTextBox.setText( record.getKeyName().getName() );
        formContainer.addRow( constants.configurationNameColumn(), nameTextBox, true );

        platformListBox = new TypedListBoxWidget<Long>( new IntegerConverter() );
        loadPlatformListBox( platformListBox, record.getDevice().getPlatform().getKey() );
        formContainer.addRow( constants.configurationPlatformColumn(), platformListBox, true );

        saveButton = new ButtonWidget( constants.saveButtonName(), new ClickHandler() {
            public void onClick( ClickEvent event ) {
                parentPanel.clearMessages();
                if ( formContainer.validate() ) {
                    callback.save( DeviceDetailView.this );
                }
            }

        } );
        saveButton.addStyleDependentName( StyleNames.COMMIT_BUTTON_STYLE );
        formContainer.addButton( saveButton );

        ButtonWidget cancelButton = new ButtonWidget( constants.cancelButtonName(), new ClickHandler() {
            public void onClick( ClickEvent event ) {
                parentPanel.clearMessages();
                callback.cancel( DeviceDetailView.this );
            }
        } );
        cancelButton.addStyleDependentName( StyleNames.DATALOSS_BUTTON_STYLE );
        formContainer.addButton( cancelButton );
    }

    private void loadPlatformListBox( final TypedListBoxWidget<Long> lbPlatform,
            final Long selected ) {
        lbPlatform.clear();
        contractManagerDropDownService.getPlatformList( new NeptuneAsyncCallback<List<UiPlatform>>() {

            @Override
            public void onNeptuneFailure( Throwable caught ) {
                Window.alert( constants.failureGettingContentProviders() );
            }

            @Override
            public void onNeptuneSuccess( List<UiPlatform> result ) {
                lbPlatform.addItem( "", null );
                for ( UiPlatform platform : result ) {
                    lbPlatform.addItem( platform.getName(), platform.getKey() );
                }
                lbPlatform.setSelectedItem( selected );
            }
        } );
    }

    private void updateWidgetsAccess() {
        boolean isCreating = record.getKey() == null;
        saveButton.setVisible( saveButtonIsVisible( isCreating ) );
    }

    private boolean saveButtonIsVisible( boolean isCreating ) {
        boolean visible = ( isCreating && ClientAuthorizationManager
                .isAuthorized( Permissions.CONTRACT_CREATE ) )
                || ( !isCreating && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY ) );
        return visible;
    }

    @Override
    public void commit() {
        record.getDevice().setName( nameTextBox.getText().trim() );
        record.getDevice().getPlatform().setKey( platformListBox.getSelectedItem() );
    }

    @Override
    public UiDeviceRecord getRecord() {
        return record;
    }

    @Override
    public void revert() {
        nameTextBox.setText( record.getDevice().getName() );
        platformListBox.setSelectedItem( record.getDevice().getPlatform().getKey() );

        updateWidgetsAccess();
    }

    @Override
    public String getStyleName() {
        return null;
    }

    @Override
    public Widget getWidget() {
        mainContainer.add( formContainer );
        return mainContainer;
    }

    @Override
    public void release() {
    }

    @Override
    public void saveFailed( Throwable throwable ) {
        if ( throwable instanceof ValidationException ) {
            ValidationException ve = (ValidationException) throwable;
            for ( String message : ve.getValidationMessages() ) {
                this.parentPanel.getErrorPanel().addMessage( message );
            }
        } else {
            this.parentPanel.getErrorPanel().showMessage( throwable.getLocalizedMessage() );
        }
    }

    @Override
    protected void onUnload() {
        super.onUnload();
    }
}
