package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device;

import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDataProvider;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailFeature;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownListPanel;

/**
 * Table that shows the list of license types.
 * 
 * @author Daniel Paranhos
 * 
 */
public class DeviceListPanel extends DropDownListPanel<UiDeviceRecord> {

    public DeviceListPanel() {
        super( true, true );
    }

    @Override
    protected DropDownDetailFeature<UiDeviceRecord> getDropDownDetailFeature() {
        return new DeviceDetailFeature(this);
    }

    @Override
    protected DropDownDataProvider<UiDeviceRecord> getDataProvider() {
        return new DeviceDataProvider();
    }

    @Override
    public String getCreateHeading() {
        return constants.deviceCreateHeading();
    }

    @Override
    public String getEditHeading() {
        return constants.deviceViewEditHeading();
    }

    @Override
    public String getListHeading() {
        return constants.deviceListHeading();
    }

}
