package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device;

import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldDetailView;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class DeviceMainDetailView extends ConfigurableFieldDetailView {

    public DeviceMainDetailView( final UiKeyNameRecord record,
            final DetailViewCallback<Long, UiKeyNameRecord> callback ) {
        super( record, callback );

        final DeviceListPanel listPanel = new DeviceListPanel();
        mainContainer.add( listPanel );

        ButtonWidget backButton = new ButtonWidget( constants.backButtonName(), new ClickHandler() {
            public void onClick( ClickEvent event ) {
                listPanel.clearMessages();
                callback.cancel( DeviceMainDetailView.this );
            }
        } );
        backButton.addStyleDependentName( StyleNames.DATALOSS_BUTTON_STYLE );
        mainContainer.add( backButton );
    }

}
