package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.device;

import com.ericsson.cms.contractmgmt.client.model.UiDevice;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;

/**
 * Represents a device record in the device list view.
 * 
 * @author Daniel Paranhos
 * 
 */
public class UiDeviceRecord extends UiKeyNameRecord {

    private UiDevice device;

    public UiDeviceRecord() {
        this.setKeyName( new UiKeyName() );
        this.device = new UiDevice();
    }

    public UiDeviceRecord( UiDevice device ) {
        this.device = device;
        UiKeyName keyName = new UiKeyName();
        keyName.setKey( device.getKey() );
        keyName.setName( device.getName() );
        this.setKeyName( keyName );
    }

    @Override
    public Long getKey() {
        return getKeyName().getKey();
    }
    
    /**
     * @param keyName
     *            the keyName to set
     */
    @Override
    public void setKeyName( UiKeyName keyName ) {
        super.setKeyName( keyName );
        device.setKey( keyName.getKey() );
        device.setName( keyName.getName() );
    }

    /**
     * @return the device
     */
    public UiDevice getDevice() {
        return device;
    }

    /**
     * @param device
     *            the device to set
     */
    public void setDevice( UiDevice device ) {
        this.device = device;
    }

}
