package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic;

import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;

public class GenericAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?fieldType=1&recordId=1
    private static final String FIELD_TYPE = "fieldType";
    private static final String RECORD_ID = "recordId";
    private static final String PARAMETER_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    private final GenericListPanel widget;

    public GenericAnchorChangeListener( GenericListPanel listPanel ) {
        this.widget = listPanel;
    }

    @Override
    public void anchorChanged( String anchor ) {
        /* Check for anchor with title list id */
        if ( anchor != null && anchor.contains( FIELD_TYPE ) && anchor.contains( RECORD_ID ) ) {
            widget.getTable().reset();

            // skip the first char
            anchor = anchor.substring( 1 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( FIELD_TYPE ) ) {
                    Long.parseLong( paramValue[1] );
                } else if ( paramValue[0].equalsIgnoreCase( RECORD_ID ) ) {
                    Long.parseLong( paramValue[1] );
                }
            }

        } else {
            widget.getTable().setAnchor( anchor );
        }
    }
}
