package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNames;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

/**
 * Generic data provider which operates on drop-down values.
 * 
 * @author Daniel Paranhos
 * 
 */
public class GenericDataProvider implements DataProvider<Long, UiKeyNameRecord> {

    private ConfigurableFieldTypeEnum fieldType;

    // columns for this table
    protected final List<Column<?, UiKeyNameRecord>> columns;
    private final ColumnBase<String, UiKeyNameRecord> nameColumn;
    private PageFeature parentPageFeature;
    private SortFeatureImpl<Long, UiKeyNameRecord> parentSortFeature;

    protected ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    protected List<UiKeyNameRecord> records;

    // column names
    private static String NAME_COLUMN = "name";

    // lists panel
    private IBusyNotifier busyNotifier;

    private IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT
            .create( IContractManagerDropDownService.class );

    public GenericDataProvider( ConfigurableFieldTypeEnum fieldType ) {
        this.fieldType = fieldType;
        this.records = new ArrayList<UiKeyNameRecord>();

        columns = new ArrayList<Column<?, UiKeyNameRecord>>();

        nameColumn = new ColumnBase<String, UiKeyNameRecord>( NAME_COLUMN,
                constants.configurationDropDownNameColumn() ) {
            public View<String> getView( UiKeyNameRecord record ) {
                return new LabelStringView( record.getKeyName().getName() );
            }

        };
        nameColumn.setCellStyle( TableConstants.STYLE_DATACELL_TEXT );
        columns.add( nameColumn );

    }

    public void getRecords( final AsyncCallback<List<UiKeyNameRecord>> callback ) {
        notifyBusyStart();
        int length = 0;
        int start = 0;
        if ( parentPageFeature != null ) {
            length = parentPageFeature.getPageSize();
            start = ( parentPageFeature.getPageNumber() - 1 ) * length;
        }

        String sortColumn = "";
        boolean isAcending = true;
        if ( parentSortFeature != null ) {
            sortColumn = getParentSortFeature().getSortColumnName();
            isAcending = getParentSortFeature().isAscending();
        }

        contractManagerDropDownService.getGenericDropDownKeyNameList( start, length, sortColumn, isAcending,
                fieldType, new NeptuneAsyncCallback<UiKeyNames>() {

                    @Override
                    public void onNeptuneFailure( Throwable caught ) {
                        callback.onFailure( caught );
                    }

                    @Override
                    public void onNeptuneSuccess( UiKeyNames result ) {
                        records.clear();
                        for ( UiKeyName uiKeyName : result.getRecords() ) {
                            records.add( new UiKeyNameRecord( uiKeyName ) );
                        }
                        if ( parentPageFeature != null ) {
                            parentPageFeature.setRecordCount( result.getTotalCount() );
                        }
                        callback.onSuccess( records );
                        notifyBusyFinish();
                    }

                } );
    }

    public ColumnBase<String, UiKeyNameRecord> getDefaultSortColumn() {
        return nameColumn;
    }

    public List<Column<?, UiKeyNameRecord>> getSortColumns() {
        return columns;
    }

    @Override
    public List<Column<?, UiKeyNameRecord>> getColumns() {
        return columns;
    }

    @Override
    public void getRecord( Long key, final AsyncCallback<UiKeyNameRecord> callback ) {
        for ( UiKeyNameRecord record : records ) {
            if ( record.getKey().equals( key ) ) {
                callback.onSuccess( record );
                break;
            }
        }
    }

    @Override
    public void initialize( AsyncCallback<Void> callback ) {
        callback.onSuccess( null );
    }

    @Override
    public boolean isCheckboxEnabled() {
        if (fieldType == ConfigurableFieldTypeEnum.MetaFormat) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isRecordCountEnabled() {
        return true;
    }

    public static interface IBusyNotifier {
        void startingToBeBusy();

        void doneBeingBusy();
    }

    public void setBusyNotifier( IBusyNotifier busyNotifier ) {
        this.busyNotifier = busyNotifier;
    }

    protected void notifyBusyStart() {
        if ( busyNotifier != null ) {
            busyNotifier.startingToBeBusy();
        }
    }

    protected void notifyBusyFinish() {
        if ( busyNotifier != null ) {
            busyNotifier.doneBeingBusy();
        }
    }

    /**
     * @return the parentPageFeature
     */
    public PageFeature getParentPageFeature() {
        return parentPageFeature;
    }

    /**
     * @param parentPageFeature
     *            the parentPageFeature to set
     */
    public void setParentPageFeature( PageFeature parentPageFeature ) {
        this.parentPageFeature = parentPageFeature;
    }

    /**
     * @return the parentSortFeature
     */
    public SortFeatureImpl<Long, UiKeyNameRecord> getParentSortFeature() {
        return parentSortFeature;
    }

    /**
     * @param parentSortFeature
     *            the parentSortFeature to set
     */
    public void setParentSortFeature( SortFeatureImpl<Long, UiKeyNameRecord> parentSortFeature ) {
        this.parentSortFeature = parentSortFeature;
    }

}
