package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.model.UiKeyName;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.DropDownDetailView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;

/**
 * Handles detail view for a generic type.
 * 
 * @author Daniel Paranhos
 * 
 */
public class GenericDetailFeature extends AbstractDetailFeature<Long, UiKeyNameRecord> {
    
    private final ConfigurableFieldTypeEnum fieldType;
    private final IContractManagerDropDownServiceAsync contractManagerDropDownService = GWT
            .create(IContractManagerDropDownService.class);
    private final ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create(ContractComponentMessages.class);
    private final GenericListPanel parentPanel;

    public GenericDetailFeature(GenericListPanel parentPanel, ConfigurableFieldTypeEnum fieldType) {
        super( new UiLongKeySerializer() );
        this.parentPanel = parentPanel;
        this.fieldType = fieldType;
    }

    private final ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    /*
     * The detail link is shown only if the user has asset view permissions and the column is the name column.
     */
    @Override
    public boolean hasDetailLink( Column<?, UiKeyNameRecord> column ) {
        if (fieldType.equals(ConfigurableFieldTypeEnum.MetaFormat)) {
            return false;
        }
        return column.getDisplayName().equals( constants.contractNameColumn() )
                && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_VIEW );
    }

    @Override
    public boolean showCreateButton() {
        if (fieldType.equals(ConfigurableFieldTypeEnum.MetaFormat)) {
            return false;
        } else if (fieldType.equals(ConfigurableFieldTypeEnum.Frequency)) {
            // Currently Frequency is only part of the User Defined field. In case, it becomes
            // configurable from outside, we will need to change this behavior
            if (this.parentPanel.isModifying()) {
                return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY );
            } else {
                return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE );
            }
        } else {
            return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE );
        }
    }

    @Override
    public boolean showDeleteButton() {
        if (fieldType.equals(ConfigurableFieldTypeEnum.MetaFormat)) {
            return false;
        } else if (fieldType.equals(ConfigurableFieldTypeEnum.Frequency)) {
            // Currently Frequency is only part of the User Defined field. In case, it becomes
            // configurable from outside, we will need to change this behavior
            if (this.parentPanel.isModifying()) {
                return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_MODIFY );
            } else {
                return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE );
            }
        } else {
            return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_DELETE );
        }
    }

    @Override
    public void delete(List<UiKeyNameRecord> records,
            final AsyncCallback<Void> callback) {
        if (records.size() > 0) {
            if (Window.confirm(messages.deleteGenericConfirmation() + " " + fieldType.getDisplayName())) {
                List<UiKeyName> keyNames = new ArrayList<UiKeyName>();
                for (UiKeyNameRecord record : records) {
                    keyNames.add(record.getKeyName());
                }
                parentPanel.clearMessages();
                contractManagerDropDownService.deleteGenericDropDownKeyNames(
                        keyNames, this.fieldType,
                        new NeptuneAsyncCallback<Void>() {

                            @Override
                            public void onNeptuneFailure(Throwable caught) {
                                parentPanel.getTable().refresh();
                                parentPanel.getErrorPanel().showMessage(messages.deleteGenericError() + " "
                                                + fieldType.getDisplayName());
                                if (caught instanceof ValidationException ) {
                                    ValidationException ve = (ValidationException) caught;
                                    for ( String message : ve.getValidationMessages() ) {
                                        parentPanel.getErrorPanel().addMessage(message);
                                    }
                                } else {
                                    callback.onFailure(caught);
                                }
                            }

                            @Override
                            public void onNeptuneSuccess(Void result) {
                                parentPanel.getSuccessPanel().showMessage(fieldType.getDisplayName() + " "
                                        + messages.deleteGenericSucceeded());
                                callback.onSuccess(null);
                            }
                        });
            }
        } else {
            Window.alert(messages.noGenericSelected() + " " + fieldType.getDisplayName());
        }
    }

    @Override
    public void getNew( AsyncCallback<UiKeyNameRecord> callback ) {
        this.parentPanel.clearMessages();
        callback.onSuccess( new UiKeyNameRecord( new UiKeyName() ) );
    }

    @Override
    public DetailView<Long, UiKeyNameRecord> getView( UiKeyNameRecord record,
            DetailViewCallback<Long, UiKeyNameRecord> callback ) {
        this.parentPanel.clearMessages();
        boolean parentModifying = fieldType.equals(ConfigurableFieldTypeEnum.Frequency) ? this.parentPanel.isModifying() : false;
        DropDownDetailView view = new DropDownDetailView( record, callback, parentModifying, null );
        return view;
    }

    @Override
    public void save( UiKeyNameRecord record, final AsyncCallback<Void> callback ) {
        parentPanel.clearMessages();
        contractManagerDropDownService.saveGenericDropDownKeyName(record.getKeyName(), this.fieldType,
                new NeptuneAsyncCallback<Void>() {

                    @Override
                    public void onNeptuneFailure(Throwable caught) {
                        callback.onFailure(caught);
                    }

                    @Override
                    public void onNeptuneSuccess(Void result) {
                        parentPanel.getSuccessPanel().showMessage(fieldType.getDisplayName() + " "
                                + messages.saveGenericSucceeded());
                        callback.onSuccess(null);
                    }
                });
    }

}
