package com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiKeyNameRecord;
import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;
import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;
import com.ericsson.cms.contractmgmt.client.tab.config.configurablefield.ConfigurableFieldTypeEnum;
import com.ericsson.cms.contractmgmt.client.tab.config.dropdown.generic.GenericDataProvider.IBusyNotifier;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Table that shows the list of drop-down values.
 * 
 * @author Daniel Paranhos
 * 
 */
public class GenericListPanel extends Composite {

    private ConfigurableFieldTypeEnum fieldType;
    // table related
    private GenericDataProvider dataProvider;
    private GenericDetailFeature detailFeature;
    private AnchorChangeListener anchorChangeListener;

    // widgets used in this view
    private VerticalContainer mainContainer;
    private Table<Long, UiKeyNameRecord> table;
    private BusyIndicator busyIndicator = new BusyIndicator();

    private HeaderPanel header;

    private final SuccessPanel successPanel = new SuccessPanel();

    private final ErrorPanel errorPanel = new ErrorPanel();

    protected ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );
    private boolean isModifying;

    // spacing between the table and message panel
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";

    public GenericListPanel( ConfigurableFieldTypeEnum fieldType, boolean isModifying ) {
        this.fieldType = fieldType;
        this.isModifying = isModifying;
        this.dataProvider = new GenericDataProvider( fieldType );
        dataProvider.setBusyNotifier( new IBusyNotifier() {
            @Override
            public void startingToBeBusy() {
                busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                busyIndicator.hide();
            }
        } );
        init();
    }

    private void init() {
        initWidgets();
        setContainers();
    }

    public SuccessPanel getSuccessPanel() {
        return successPanel;
    }

    public ErrorPanel getErrorPanel() {
        return errorPanel;
    }

    private void setContainers() {
        mainContainer.add( header );
        mainContainer.add(successPanel);
        mainContainer.add(errorPanel);
        mainContainer.add( table );
    }

    private void initWidgets() {
        mainContainer = new VerticalContainer();
        mainContainer.setSpacing( SPACING );
        mainContainer.setStylePrimaryName( STYLE_NAME );
        this.initWidget( mainContainer );

        header = new HeaderPanel( "" );

        table = new Table<Long, UiKeyNameRecord>( dataProvider );
        table.addTableViewChangeHandler( new TableViewChangeHandler<Long, UiKeyNameRecord>() {
            @Override
            public void onShowDetailView( TableDetailViewEvent<Long, UiKeyNameRecord> event ) {
                if ( event.isCreateView() ) {
                    header.setLabel( getDetailsHeading() );
                } else {
                    header.setLabel( getDetailsHeading() + " " + event.getRecord().getKeyName().getName() );
                }
            }

            @Override
            public void onShowListView( TableViewEvent event ) {
                header.setLabel( getListHeading() );
            }
        } );

        // detail feature
        detailFeature = new GenericDetailFeature( this, fieldType );

        if ( fieldType.hasPageFeature() ) {
            PageFeature pageFeature = new PageFeatureImpl();
            dataProvider.setParentPageFeature( pageFeature );
            table.addPageFeature( pageFeature );
        }

        if ( fieldType.hasSortFeature() ) {
            // sort feature
            SortFeatureImpl<Long, UiKeyNameRecord> sortFeature = new SortFeatureImpl<Long, UiKeyNameRecord>(
                    dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING );
            dataProvider.setParentSortFeature( sortFeature );
            for ( Column<?, UiKeyNameRecord> col : dataProvider.getSortColumns() ) {
                sortFeature.addSortableColumn( col );
            }
            dataProvider.setParentSortFeature( sortFeature );
        }

        table.addDetailFeature( detailFeature );

        table.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure( Throwable caught ) {
            }

            @Override
            public void onNeptuneSuccess( Void result ) {
                table.refresh();
            }
        } );

        anchorChangeListener = new GenericAnchorChangeListener( this );
    }

    public String getDetailsHeading() {
        return fieldType.getDisplayName() + " " + constants.genericDetailsHeading();
    }

    public String getListHeading() {
        return fieldType.getDisplayName() + " " + constants.genericListHeading();
    }

    public Table<Long, UiKeyNameRecord> getTable() {
        return this.table;
    }

    public AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    /**
     * @param reverseAnchorChangeListener
     *            the reverseAnchorChangeListener to set
     */
    public void setReverseAnchorChangeListener( AnchorChangeListener reverseAnchorChangeListener ) {
        table.setAnchorChangeNotifier( reverseAnchorChangeListener );
    }

    public void clearMessages() {
        this.successPanel.reset();
        this.errorPanel.reset();
    }

    /**
     * @return the isModifying
     */
    public boolean isModifying() {
        return isModifying;
    }
}
