package com.ericsson.cms.contractmgmt.client.tab.contacts;

import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;

public class ContactAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?contactId=1
    private static String CONTACT_ID = "contactId";
    private static String PARAMETER_DELIMITER = "&";
    private static String VALUE_DELIMITER = "=";
    private final ContactListPanel widget;

    public ContactAnchorChangeListener( ContactListPanel listPanel ) {
        this.widget = listPanel;
    }

    @Override
    public void anchorChanged( String anchor ) {

        /* Check for anchor with title list id */
        if ( anchor != null && anchor.contains( CONTACT_ID ) ) {
            widget.getContactTable().reset();

            // skip the first char
            anchor = anchor.substring( 1 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( CONTACT_ID ) ) {
                    Long.parseLong( paramValue[1] );
                }
            }

        } else {
            widget.getContactTable().setAnchor( anchor );
        }
    }
}
