package com.ericsson.cms.contractmgmt.client.tab.contacts;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.model.UiContact;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.ericsson.cms.contractmgmt.client.exception.UiContractManagerException;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;

/**
 * Handles detail view for a given copyright holder.
 * 
 * @author Daniel Paranhos
 * 
 */
public class ContactDetailFeature extends AbstractDetailFeature<Long, UiContactRecord> {

	private ContactListPanel parentPanel;

	private ContractComponentConstants constants = (ContractComponentConstants) GWT
			.create(ContractComponentConstants.class);
	
	private ContractComponentMessages messages = (ContractComponentMessages) GWT
    .create(ContractComponentMessages.class);

	private IContractManagerServiceAsync contractManagerService = GWT.create(IContractManagerService.class);

	public ContactDetailFeature(ContactListPanel parentPanel) {
		super(new UiLongKeySerializer());
		this.parentPanel = parentPanel;
	}
	
	@Override
	public void delete(List<UiContactRecord> records, final AsyncCallback<Void> callback) {
	    if(records.size() == 0 || records == null){
	        Window.alert(messages.noRecordSelected());
	    } else {
	        if (parentPanel.isEditing) {
	            
	            List<UiContact> contactList = new ArrayList<UiContact>();
	            for (UiContactRecord record : records) {
	                contactList.add(record.getContact());
	            }
	            
	            contractManagerService.deleteContacts(contactList,parentPanel.getContactType(),parentPanel.getParentId(), new NeptuneAsyncCallback<Boolean>() {
	                
	                @Override
	                public void onNeptuneFailure(Throwable caught) {
	                    callback.onFailure(caught);
	                }
	                
	                @Override
	                public void onNeptuneSuccess(Boolean result) {
	                    callback.onSuccess(null);
	                }
	                
	            });
	            
	        } else {
	            for (int i = 0; i < parentPanel.getUiContactList().size(); i++) {
	                UiContact contact = parentPanel.getUiContactList().get(i);
	                for (UiContactRecord record : records) {
	                    if (record.getContact().getName().equalsIgnoreCase(contact.getName())
	                            && record.getContact().getEmail().equalsIgnoreCase(contact.getEmail())) {
	                        parentPanel.getUiContactList().remove(i);
	                    }
	                }
	                
	            }
	            callback.onSuccess(null);
	        }
	    }
	}

	@Override
	public void getNew(AsyncCallback<UiContactRecord> callback) {
		if (callback != null) {
			callback.onSuccess(new UiContactRecord(new UiContact()));
		}
	}

	@Override
	public DetailView<Long, UiContactRecord> getView(UiContactRecord record,
			DetailViewCallback<Long, UiContactRecord> callback) {
		ContactDetailView view = new ContactDetailView(record, parentPanel.isEditing, parentPanel,  callback);
		return view;
	}

	/*
	 * The detail link is shown only if the user has asset view permissions and
	 * the column is the name column.
	 */
	@Override
	public boolean hasDetailLink(Column<?, UiContactRecord> column) {
		return column.getDisplayName().equals(constants.copyrightHolderNameColumn())
				&& ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_VIEW);
	}

	@Override
	public void save(UiContactRecord record, final AsyncCallback<Void> callback) {
		if (parentPanel.isEditing) {
			contractManagerService.saveContact(record.getContact(), parentPanel.getContactType(),parentPanel.getParentId(), new NeptuneAsyncCallback<Boolean>() {

				@Override
				public void onNeptuneFailure(Throwable caught) {
					callback.onFailure(caught);
				}

				@Override
				public void onNeptuneSuccess(Boolean result) {
					callback.onSuccess(null);
				}
			});
		} else {
			if(!parentPanel.getUiContactList().contains(record.getContact()) && validateEmail(record)){
				parentPanel.getUiContactList().add(record.getContact());
				callback.onSuccess(null);
			} else {
			    callback.onFailure(new UiContractManagerException(messages.saveContactSameEmail()));
			}	
		}
	}

	/*
	 * If when creating there's already an contact with the same email as 
	 * the contact being created return false
	 * */
	private boolean validateEmail(UiContactRecord record) {
	    for(UiContact contact : parentPanel.getUiContactList()){
	        if(contact.getEmail().trim().equals(record.getContact().getEmail().trim())){
	            return false;
	        }
	    }
        return true;
    }

    @Override
	public boolean showCreateButton() {
		return ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_MODIFY) || ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_CREATE);
	}

	@Override
	public boolean showDeleteButton() {
		return ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_MODIFY);
	}
	
}
