package com.ericsson.cms.contractmgmt.client.tab.contacts;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.model.UiContact;
import com.ericsson.cms.contractmgmt.client.model.UiContactType;
import com.ericsson.cms.contractmgmt.client.tab.contacts.ContactDataProvider.IBusyNotifier;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * Table that shows the list of copyright holders.
 * 
 * @author Daniel Paranhos
 * 
 */
public class ContactListPanel extends Composite {
	
    // table related
    private ContactDataProvider dataProvider;
    private PageFeature pageFeature;
    private SortFeatureImpl<Long, UiContactRecord> sortFeature;
    private ContactDetailFeature detailFeature;
    private BookmarkFeature bookmarkFeature;
    private AnchorChangeListener anchorChangeListener;

    // widgets used in this view
    private VerticalContainer mainContainer;
    private Table<Long, UiContactRecord> table;
    private BusyIndicator busyIndicator = new BusyIndicator();

    private HeaderPanel header;
    
    public boolean isEditing = false;
    private List<UiContact> uiContactList = new ArrayList<UiContact>();
    private UiContactType contactType;
    private Long parentId;

    private ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );

    // spacing between the table and message panel
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-ContractPanel";

    public ContactListPanel() {
        this.dataProvider = new ContactDataProvider(this);
        dataProvider.setBusyNotifier( new IBusyNotifier() {
            @Override
            public void startingToBeBusy() {
                busyIndicator.center();
            }

            @Override
            public void doneBeingBusy() {
                busyIndicator.hide();
            }
        } );
        init();
    }

    private void init() {
        initWidgets();
        setContainers();
    }

    private void setContainers() {
        mainContainer.add( header );
        mainContainer.add( table );
    }

    private void initWidgets() {
        mainContainer = new VerticalContainer();
        mainContainer.setSpacing( SPACING );
        mainContainer.setStylePrimaryName( STYLE_NAME );
        this.initWidget( mainContainer );

        header = new HeaderPanel( "" );

        table = new Table<Long, UiContactRecord>( dataProvider );
        table.addTableViewChangeHandler( new TableViewChangeHandler<Long, UiContactRecord>() {
            @Override
            public void onShowDetailView( TableDetailViewEvent<Long, UiContactRecord> event ) {
                if ( event.isCreateView() ) {
                    header.setLabel( constants.contactCreateHeading() );
                } 
            }

            @Override
            public void onShowListView( TableViewEvent event ) {
                header.setLabel( constants.copyrightHolderContactSectionHeading() );
            }
        } );

        // page feature
        pageFeature = new PageFeatureImpl();
        dataProvider.setParentPageFeature( pageFeature );

        // sort feature
        sortFeature = new SortFeatureImpl<Long, UiContactRecord>(
                dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING );
        for ( Column<?, UiContactRecord> col : dataProvider.getSortColumns() ) {
            sortFeature.addSortableColumn( col );
        }
        dataProvider.setParentSortFeature( sortFeature );
        
        // bookmark feature
        bookmarkFeature = new BookmarkFeatureImpl();

        // detail feature
        detailFeature = new ContactDetailFeature( this );

        table.addSortFeature( sortFeature );
        table.addDetailFeature( detailFeature );
        table.addBookmarkFeature(bookmarkFeature);

        table.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure( Throwable caught ) {
            }

            @Override
            public void onNeptuneSuccess( Void result ) {
            }
        } );

        anchorChangeListener = new ContactAnchorChangeListener( this );
    }

    public Table<Long, UiContactRecord> getContactTable() {
        return this.table;
    }

    public AnchorChangeListener getAnchorChangeListener() {
        return this.anchorChangeListener;
    }

    /**
     * @param reverseAnchorChangeListener
     *            the reverseAnchorChangeListener to set
     */
    public void setReverseAnchorChangeListener( AnchorChangeListener reverseAnchorChangeListener ) {
        table.setAnchorChangeNotifier( reverseAnchorChangeListener );
    }

	public List<UiContact> getUiContactList() {
		return uiContactList;
	}

	public void setUiContactList(List<UiContact> uiContactList) {
		this.uiContactList = uiContactList;
	}

	/**
	 * @return the contactType
	 */
	public UiContactType getContactType() {
		return contactType;
	}

	/**
	 * @param contactType the contactType to set
	 */
	public void setContactType(UiContactType contactType) {
		this.contactType = contactType;
	}

	/**
	 * @return the parentId
	 */
	public Long getParentId() {
		return parentId;
	}

	/**
	 * @param parentId the parentId to set
	 */
	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}
    
    
}
