package com.ericsson.cms.contractmgmt.client.tab.contract;

import com.ericsson.cms.contractmgmt.client.model.UiContract;
import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class ContractAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?contractId=1
    private static final String CONTRACT_ID = "contractId";
    private static final String COPYRIGHT_HOLDER_ID = "copyrightId";
    private static final String PARAMETER_DELIMITER = "&";
    private static final String VALUE_DELIMITER = "=";
    private final ContractListPanel widget;

    public ContractAnchorChangeListener( ContractListPanel listPanel ) {
        this.widget = listPanel;
    }

    @Override
    public void anchorChanged( String anchor ) {
        long contractId = 0L;
        long copyrightHolderId = 0L;

        /* Check for anchor with contract id */
        if ( anchor != null && anchor.contains( CONTRACT_ID ) ) {
            widget.getContractTable().reset();

            // skip the first char
            anchor = anchor.substring( 5 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( CONTRACT_ID ) ) {
                    contractId = Long.parseLong( paramValue[1] );
                }
            }
            
            IContractManagerServiceAsync cmService = GWT.create( IContractManagerService.class );
            cmService.getContract(contractId, new NeptuneAsyncCallback<UiContract>() {

				@Override
				public void onNeptuneFailure(Throwable caught) {
					 Window.alert( caught.getLocalizedMessage() );
				}

				@Override
				public void onNeptuneSuccess(UiContract result) {
					widget.getContractTable().showDetailView(new UiContractRecord(result));	
				}	
			
            } );

        } else if (anchor != null && !anchor.contains( CONTRACT_ID ) && anchor.contains(COPYRIGHT_HOLDER_ID)) {
            widget.getContractTable().reset();

            // skip the first char
            anchor = anchor.substring( 7 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( COPYRIGHT_HOLDER_ID ) ) {
                    copyrightHolderId = Long.parseLong( paramValue[1] );
                }
            }
            
            final UiContract uiContract = new UiContract();
            
            IContractManagerServiceAsync cmService = GWT.create( IContractManagerService.class );
            
            cmService.getCopyrightHolder(copyrightHolderId, new NeptuneAsyncCallback<UiCopyrightHolder>() {

                @Override
                public void onNeptuneFailure(Throwable caught) {
                    Window.alert( caught.getLocalizedMessage() );
                }

                @Override
                public void onNeptuneSuccess(UiCopyrightHolder result) {
                    uiContract.setCopyrightHolder(result);
                    uiContract.setName("");
                    widget.getContractTable().showDetailView(new UiContractRecord(uiContract)); 
                }
            });
            
        }else {
            widget.clearMessages();
            widget.getContractTable().setAnchor( anchor );
        }
    }
}
