package com.ericsson.cms.contractmgmt.client.tab.contract;



import java.util.ArrayList;

import java.util.Collection;

import java.util.HashMap;

import java.util.List;

import java.util.Map;

import java.util.Map.Entry;

import java.util.Set;



import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;

import com.ericsson.cms.contractmgmt.client.Permissions;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldValidator;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;

import com.ericsson.cms.contractmgmt.client.document.DocumentComponentFactory;

import com.ericsson.cms.contractmgmt.client.model.UiContactType;

import com.ericsson.cms.contractmgmt.client.model.UiContract;

import com.ericsson.cms.contractmgmt.client.model.UiContractType;

import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;

import com.ericsson.cms.contractmgmt.client.model.UiDeal;

import com.ericsson.cms.contractmgmt.client.model.UiDocument;

import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;

import com.ericsson.cms.contractmgmt.client.model.UiKeyName;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownService;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerDropDownServiceAsync;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;

import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;

import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;

import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;

import com.ericsson.cms.contractmgmt.client.tab.config.PositiveIntegerConverter;

import com.ericsson.cms.contractmgmt.client.tab.contacts.ContactListPanel;

import com.google.gwt.core.client.GWT;

import com.google.gwt.event.dom.client.ClickEvent;

import com.google.gwt.event.dom.client.ClickHandler;

import com.google.gwt.i18n.client.DateTimeFormat;

import com.google.gwt.user.client.History;

import com.google.gwt.user.client.Window;

import com.google.gwt.user.client.ui.Composite;

import com.google.gwt.user.client.ui.FormPanel;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;

import com.google.gwt.user.client.ui.Widget;

import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;

import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedDateBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.DateConverter;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;

import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;



public class ContractDetailView extends Composite implements DetailView<Long, UiContractRecord> {



    private static final String ROW_HEADER_STYLE = "contract-PlatformTable-row-header";

    private static final String TABLE_STYLE = "contract-PlatformTable";

    private static final String ROW_STYLE = "contract-PlatformTable-row";

    private static final String ROW_BODY_STYLE = "contract-PlatformTable-row-body";

    private static final String CELL_STYLE = "contract-PlatformTable-cell";

    private static final String CELL_HEADER_STYLE = "contract-PlatformTable-cell-header";

    private static final String LINK_BEHAVIOUR = "contract-Link";



    private static final String CONTENT_LISTBOX_WIDTH = "130px";

    private static final String TEXTBOXWIDGET_WIDTH = "150px";

    private static final String DATE_BOX_WIDTH = "75px";

    private static final int MAX_LENGTH = 50;

    private static final int EXTERNAL_ID_MAX_LENGTH = 100;



    private final ContractComponentConstants constants = (ContractComponentConstants) GWT

            .create(ContractComponentConstants.class);



    private final ContractComponentMessages messages = (ContractComponentMessages) GWT

            .create(ContractComponentMessages.class);



    private final IContractManagerServiceAsync contractManagerService = GWT.create(IContractManagerService.class);

    private final IContractManagerDropDownServiceAsync dropDownService = GWT.create(IContractManagerDropDownService.class);



    private final UiContractRecord record;

    private final DetailViewCallback<Long, UiContractRecord> callback;

    private final VerticalContainer mainContainer;

    private FormContainer dealsContainer;

    private ContractFormContainer formUserDefinedFields;



    private ContractFormContainer formContainer;



    private FlexTableContainer tableDeals;



    private ButtonWidget removeButton;

    private ButtonWidget addButton;

    private ButtonWidget saveButton;

    private ButtonWidget cancelButton;

    private CheckBoxWidget check;



    private DocumentComponentFactory documentComponent;



    private FormPanel form = new FormPanel();



    private final Map<DataTypeWidget<?>, UiUserDefinedField> widgetCustomFieldMap = new HashMap<DataTypeWidget<?>, UiUserDefinedField>();



    private TypedListBoxWidget<Long> copyrightHolder ;

    private final TypedListBoxWidget<Long> type;

    private TypedTextBoxWidget<String> name;

    private TypedTextBoxWidget<Integer> expiryReminder;

    private TypedTextBoxWidget<String> externalIdTextBox;



    private final SuccessPanel successPanel = new SuccessPanel();

    private final ErrorPanel errorPanel = new ErrorPanel();



    private final TypedDateBoxWidget contractCreationDate = new TypedDateBoxWidget(new DateConverter(constants.dateFormat(),

            constants.dateFormat()));

    private final TypedDateBoxWidget contractEffectiveDate = new TypedDateBoxWidget(new DateConverter(constants.dateFormat(),

            constants.dateFormat()));

    private final TypedDateBoxWidget contractExpiryDate = new TypedDateBoxWidget(new DateConverter(constants.dateFormat(),

            constants.dateFormat()));



    private HorizontalContainer buttonsContainer;



    private final ContactListPanel contactListPanel = new ContactListPanel();



    private final BusyIndicator busyIndicator = new BusyIndicator();



    private List<UiDocument> documentsList = new ArrayList<UiDocument>();

    private final List<UiUserDefinedFieldValue> userDefinedFieldValueList = new ArrayList<UiUserDefinedFieldValue>();





    public ContractDetailView(UiContractRecord record, DetailViewCallback<Long, UiContractRecord> callback) {



        this.record = record;

        this.callback = callback;



        mainContainer = new VerticalContainer();

        mainContainer.add(successPanel);

        mainContainer.add(errorPanel);

        busyIndicator.center();

        initWidget(mainContainer);



        type = getTypeListBox(0L);

    }



    private void fillForm() {

        externalIdTextBox.setValue(record.getContract().getExternalId());

        name.setValue(record.getContract().getName());



        type.setSelectedItem(record.getContract().getType().getKey());

        copyrightHolder.setSelectedItem(record.getContract().getCopyrightHolder().getKey());



        DateTimeFormat dateFormatter = DateTimeFormat.getFormat( constants.dateFormat() );

        contractCreationDate.setValue(dateFormatter.format(record.getContract().getCreationDate()));

        contractEffectiveDate.setValue(dateFormatter.format(record.getContract().getEffectiveDate()));

        contractExpiryDate.setValue(dateFormatter.format(record.getContract().getExpiryDate()));

        if(record.getContract().getDealExpiryReminder() != null){

            expiryReminder.setValue(record.getContract().getDealExpiryReminder().intValue());

        }



        for(UiDocument doc: documentsList){

            documentComponent.addRow(doc);

        }



        if(record.getContract().getUiDealsList() != null && !record.getContract().getUiDealsList().isEmpty()){

            fillDealTable(record.getContract().getUiDealsList());

        }

        contactListPanel.getContactTable().refresh();



    }





    private void addRowDeals(UiDeal deal) {



        insertRow();

        int row = getRow();



        tableDeals.getRowFormatter().setStyleName(row, TableConstants.STYLE_DATA_EVEN_ROW);



        DateTimeFormat format = DateTimeFormat.getFormat(constants.dateFormat());



        CheckBoxWidget checkBox = new CheckBoxWidget();

        tableDeals.setWidget(row, 0, checkBox);



        LabelWidget link = new LabelWidget();

        link.setText(deal.getName());

        final String url = "Contracts.Deal.Edit?dealId=" + record.getContract().getUiDealsList().get(row-1).getKey();

        link.addClickHandler(new ClickHandler() {



            @Override

            public void onClick(ClickEvent event) {

                History.newItem(url);

            }

        });

        link.setStyleName(LINK_BEHAVIOUR);

        tableDeals.setWidget(row, 1, link);



        LabelWidget label = new LabelWidget();

        label.setText(deal.getType().getName());

        tableDeals.setWidget(row, 2, label);



        label = new LabelWidget();

        label.setText(format.format(deal.getExpiryDate()));

        tableDeals.setWidget(row, 3, label);



    }



    private void insertRow(){

        tableDeals.insertRow(tableDeals.getRowCount());

        tableDeals.getRowFormatter().addStyleName(getRow(), ROW_STYLE);

        tableDeals.getRowFormatter().addStyleName(getRow(), ROW_BODY_STYLE);

    }



    private void init() {



        buttonsContainer = new HorizontalContainer();

        formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);

        formUserDefinedFields = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);



        copyrightHolder.setWidth(CONTENT_LISTBOX_WIDTH);

        copyrightHolder.ensureDebugId("contract-copyrightHolder");



        externalIdTextBox = new TypedTextBoxWidget<String>(new StringConverter());

        externalIdTextBox.setMaxLength(EXTERNAL_ID_MAX_LENGTH);



        name = new TypedTextBoxWidget<String>(new StringConverter());

        name.setMaxLength(MAX_LENGTH);

        name.setWidth(TEXTBOXWIDGET_WIDTH);

        name.ensureDebugId("contract-name");



        type.setWidth(CONTENT_LISTBOX_WIDTH);

        type.ensureDebugId("contract-type");



        contractCreationDate.setWidth(DATE_BOX_WIDTH);

        contractCreationDate.ensureDebugId("contract-createDate");



        contractEffectiveDate.setWidth(DATE_BOX_WIDTH);

        contractEffectiveDate.ensureDebugId("contract-effectiveDate");



        contractExpiryDate.setWidth(DATE_BOX_WIDTH);

        contractExpiryDate.ensureDebugId("contract-expireDate");



        expiryReminder = new TypedTextBoxWidget<Integer>(new PositiveIntegerConverter());

        expiryReminder.setWidth(TEXTBOXWIDGET_WIDTH);



        formContainer.addRow(constants.contractCopyrightHolder(), copyrightHolder, true);

        formContainer.addRow(constants.externalID(), externalIdTextBox);

        formContainer.addRow(constants.contractName(), name, true);

        formContainer.addRow(constants.contractType(), type, true);

        formContainer.addRow(constants.contractCreationDate(), contractCreationDate, true);

        formContainer.addRow(constants.contractEffectiveDate(), contractEffectiveDate, true);

        formContainer.addRow(constants.contractExpiryDate(), contractExpiryDate, true);

        formContainer.addRow(constants.contractExpiryReminder(), expiryReminder);



        final Long editing = record.getKey();

        contractManagerService.getUserDefinedFields(CustomFieldFactory.CONTRACT_SCREEN, new NeptuneAsyncCallback<List<UiUserDefinedField>>() {



            @Override

            public void onNeptuneFailure(Throwable caught) {

                errorPanel.showMessage(caught.getLocalizedMessage());

            }



            @Override

            public void onNeptuneSuccess(List<UiUserDefinedField> result) {

                CustomFieldFactory factory = new CustomFieldFactory(null);

                factory.addFieldsToForm( formUserDefinedFields, result, widgetCustomFieldMap );

                for (UiUserDefinedField uiUserDefinedField : result) {

                    UiUserDefinedFieldValue value = new UiUserDefinedFieldValue();

                    value.setIdUserDefinedField(uiUserDefinedField.getIdUserDefinedField());

                    if(editing == null){

                        value.setValue(uiUserDefinedField.getDefaultValue());

                    }

                    userDefinedFieldValueList.add(value);

                }

                createUpdateUserDefinedFieldValues();

                if(record.getContract().getUserDefinedFieldsValues() != null){

                    updateFormFromUserDefinedFieldValues(record.getContract().getUserDefinedFieldsValues());

                }

            }

        });



        buildDisclosureDeals();



        contactListPanel.setContactType(UiContactType.CONTRACT);

        mainContainer.add(formContainer);

        mainContainer.add(contactListPanel);

        documentComponent= new DocumentComponentFactory(record.getKey(), constants.contractDocuments(), UiDocumentType.CONTRACT, errorPanel);

        form = documentComponent.getDocumentPanel();

        mainContainer.add(form);

        mainContainer.add(formUserDefinedFields);

        mainContainer.add(buttonsContainer);

        addButtons();

        mainContainer.add(dealsContainer);



        if (record.getKey() != null) {

            contactListPanel.setParentId(record.getKey());

            contactListPanel.isEditing = true;

            contactListPanel.getContactTable().refresh();

            documentsList = record.getContract().getUiDocumentList();

            documentComponent.setDocumentsList(documentsList);

            fillForm();

        } else if(record.getContract().getCopyrightHolder() != null) {

            copyrightHolder.setSelectedItem(record.getContract().getCopyrightHolder().getKey());

        } else {

            contactListPanel.isEditing = false;

        }



        verifyPermissions();

        busyIndicator.hide();

    }



    private void addHeading(String heading, FlexTableContainer table) {

        /* Add the column to the header row */

        int column = table.getCellCount(0);

        table.insertCell(0, column);



        /* Update the style of the header cells */

        table.getCellFormatter().addStyleName(0, column, CELL_STYLE);

        table.getCellFormatter().addStyleName(0, column, CELL_HEADER_STYLE);



        updateHeading(table, heading, column);

    }



    private void updateHeading(FlexTableContainer table, String heading, int column) {

        /* Create new label widget or update existing widget */

        LabelWidget label = getHeadingWidget(table, column);

        if (label == null) {

            /* Update the widget displayed as the column header */

            label = new LabelWidget(heading);

            label.addStyleName(TableConstants.STYLE_HEADER_NONSORTABLE_COL_TEXT);

            table.setWidget(0, column, label);

        } else {

            label.setText(heading);

        }

    }



    private LabelWidget getHeadingWidget(FlexTableContainer table, int column) {

        Widget widget = table.getWidget(0, column);

        return widget instanceof LabelWidget ? (LabelWidget) widget : null;

    }



    private void addButtons() {



        saveButton = new ButtonWidget(constants.saveButtonName(), new ClickHandler() {



            @Override

            public void onClick(ClickEvent event) {

                if (validate()) {

                    commit();

                    ContractDetailView.this.callback.save(ContractDetailView.this);

                }

            }



        });

        saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);

        saveButton.setEnabled(false);

        saveButton.ensureDebugId("contract-save");

        buttonsContainer.add(saveButton);



        cancelButton = new ButtonWidget(constants.cancelButtonName(), new ClickHandler() {

            @Override

            public void onClick(ClickEvent event) {

                errorPanel.reset();

                History.back();

            }

        });

        cancelButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);

        buttonsContainer.add(cancelButton);



    }



    private boolean validate() {

        errorPanel.reset();

        boolean valid = formContainer.validate() && formUserDefinedFields.validate();



        if (valid) {

            if(record.getKey() != null){

                for(UiDeal uiDeal : record.getContract().getUiDealsList()){

                    if(uiDeal.getCreationDate().before(contractCreationDate.getDatePicker().getValue())){

                        valid = false;

                        errorPanel.addHeading1(messages.contractDealCreationDateValidation(uiDeal.getName()));

                    } else if(uiDeal.getEffectiveDate().before(contractEffectiveDate.getDatePicker().getValue())){

                        valid = false;

                        errorPanel.addHeading1(messages.contractDealEffectiveDateValidation(uiDeal.getName()));

                    } else if(uiDeal.getExpiryDate().after(contractExpiryDate.getDatePicker().getValue())){

                        valid = false;

                        errorPanel.addHeading1(messages.contractDealExpiryDateValidation(uiDeal.getName()));

                    }

                }

            }



            if(copyrightHolder.getSelectedItem() == 0){

                valid = false;

                errorPanel.addHeading1(constants.contractCRHValidation());

            }



            if (contractCreationDate.getDatePicker().getValue().after(contractEffectiveDate.getDatePicker().getValue())) {

                valid = false;

                errorPanel.addHeading1(constants.contractCreationDateValidation());

            }



            if (contractEffectiveDate.getDatePicker().getValue().after(contractExpiryDate.getDatePicker().getValue())) {

                valid = false;

                errorPanel.addHeading1(constants.contractEffectiveDateValidation());

            }



            Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

            for (Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {

                DataTypeWidget<?> dataTypeWidget = entry.getKey();

                CustomFieldValidator.validate(dataTypeWidget, entry.getValue());

                if (!dataTypeWidget.isValidValue() || dataTypeWidget.hasValidationError()) {

                    valid = false;

                }

            }



        }



        if (!valid) {

            errorPanel.addHeading1("Contract with validation errors.");

        }



        return valid;

    }



    private void fillDealTable(List<UiDeal> result) {

        for(UiDeal deal: result){

            addRowDeals(deal);

        }

    }



    private void buildDisclosureDeals() {

        dealsContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);

        tableDeals = new FlexTableContainer();

        tableDeals.addStyleName(TABLE_STYLE);



        /* Create the header row */

        tableDeals.insertRow(0);

        tableDeals.getRowFormatter().addStyleName(0, ROW_STYLE);

        tableDeals.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);



        createTableDealsHeader();

        LabelWidget label = new LabelWidget();

        label.setHeight("30px");

        dealsContainer.addRow("", label);

        dealsContainer.addRow(constants.contractDeals(), tableDeals);

        addButtonsDeals();

    }



    private void createTableDealsHeader() {



        check = new CheckBoxWidget();

        check.addClickHandler(new ClickHandler() {



            @Override

            public void onClick(ClickEvent event) {

                if (check.getValue()) {

                    for (int i = 0; i < tableDeals.getRowCount(); i++) {

                        CheckBoxWidget all = (CheckBoxWidget) tableDeals.getWidget(i, 0);

                        all.setValue(true);

                    }

                } else {

                    for (int i = 0; i < tableDeals.getRowCount(); i++) {

                        CheckBoxWidget all = (CheckBoxWidget) tableDeals.getWidget(i, 0);

                        all.setValue(false);

                    }

                }

            }

        });



        tableDeals.insertCell(0, 0);

        tableDeals.getRowFormatter().setStyleName(0, TableConstants.STYLE_HEADER_ROW);

        tableDeals.getCellFormatter().addStyleName(0, 0, CELL_STYLE);

        tableDeals.getCellFormatter().addStyleName(0, 0, CELL_HEADER_STYLE);

        tableDeals.setWidget(0, 0, check);



        addHeading(constants.dealName(), tableDeals);

        addHeading(constants.dealType(), tableDeals);

        addHeading(constants.dealExpiryDate(), tableDeals);



    }



    private TypedListBoxWidget<Long> getCopyrightHolderListBox(final Long selected) {

        final TypedListBoxWidget<Long> lbCopyrightHolder = new TypedListBoxWidget<Long>(new IntegerConverter());

        dropDownService.getCopyrightHolderKeyNameList(new NeptuneAsyncCallback<List<UiKeyName>>() {



            @Override

            public void onNeptuneFailure(Throwable caught) {

                Window.alert(constants.failureGettingCopyrightHolders());

            }



            @Override

            public void onNeptuneSuccess(List<UiKeyName> result) {

                fillListBox(lbCopyrightHolder, selected, result);



                init();

            }

        });



        return lbCopyrightHolder;

    }



    private void fillListBox(final TypedListBoxWidget<Long> listBox, final Long selected, List<UiKeyName> result) {

        listBox.addItem("", null);

        for (UiKeyName keyName : result) {

            listBox.addItem(keyName.getName(), keyName.getKey());

        }

        listBox.setSelectedItem(selected);

    }



    private void addButtonsDeals() {

        HorizontalContainer buttons = new HorizontalContainer();

        buttons.setSpacing(5);



        addButton = new ButtonWidget(constants.addButtonName(), new ClickHandler() {



            @Override

            public void onClick(ClickEvent event) {

                History.newItem("Contracts.Deal.Create?contractId=" + record.getKey());

            }



        });

        addButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);

        addButton.setEnabled(false);

        removeButton = new ButtonWidget(constants.removeButtonName(), new ClickHandler() {



            @Override

            public void onClick(ClickEvent event) {

                removeRow();

            }



        });

        removeButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);

        removeButton.setEnabled(false);

        buttons.add(addButton);

        buttons.add(removeButton);



        dealsContainer.addRow("", new LabelWidget());

        dealsContainer.addRow("", buttons);



    }



    private int getRow() {

        return tableDeals.getRowCount() - 1;

    }



    private void removeRow() {

        List<UiDeal> deleteList = new ArrayList<UiDeal>();



        for (int i = 1; i < tableDeals.getRowCount(); i++) {

            if (((CheckBoxWidget) tableDeals.getWidget(i, 0)).getValue()) {

                deleteList.add(record.getContract().getUiDealsList().get(i-1));

            }

        }



        if(deleteList.size() == 0){

            Window.alert(messages.noDealSelected());

        } else {



            busyIndicator.center();

            contractManagerService.deleteDeals(deleteList, new NeptuneAsyncCallback<Boolean>() {



                @Override

                public void onNeptuneFailure(Throwable caught) {

                    errorPanel.showMessage(caught.getLocalizedMessage());

                    busyIndicator.hide();

                }



                @Override

                public void onNeptuneSuccess(Boolean result) {

                    for (int i = 1; i < tableDeals.getRowCount(); i++) {

                        if (((CheckBoxWidget) tableDeals.getWidget(i, 0)).getValue()) {

                            tableDeals.removeRow(i);

                            record.getContract().getUiDealsList().remove(i-1);

                            i = i - 1;

                        }

                    }

                    if(((CheckBoxWidget)tableDeals.getWidget(0, 0)).getValue()){

                        ((CheckBoxWidget)tableDeals.getWidget(0, 0)).setValue(false);

                    }

                    busyIndicator.hide();

                }

            });

        }



    }



    private TypedListBoxWidget<Long> getTypeListBox(final Long selected) {

        final TypedListBoxWidget<Long> lbType = new TypedListBoxWidget<Long>(new IntegerConverter());

        dropDownService.getContractTypeKeyNameList(new NeptuneAsyncCallback<List<UiKeyName>>() {



            @Override

            public void onNeptuneFailure(Throwable caught) {

                errorPanel.showMessage(caught.getLocalizedMessage());

            }



            @Override

            public void onNeptuneSuccess(List<UiKeyName> result) {

                fillListBox(lbType, selected, result);

                if(record.getKey() != null){

                    getDealsList();

                }else {

                    copyrightHolder = getCopyrightHolderListBox(0L);

                }

            }



        });



        return lbType;

    }



    private void getDealsList(){

        contractManagerService.getContractDealsList(record.getKey(), new NeptuneAsyncCallback<List<UiDeal>>(){



            @Override

            public void onNeptuneFailure(Throwable caught) {

                errorPanel.showMessage(caught.getLocalizedMessage());

            }



            @Override

            public void onNeptuneSuccess(List<UiDeal> result) {

                record.getContract().setUiDealsList(result);

                copyrightHolder = getCopyrightHolderListBox(0L);

            }

        });

    }



    @Override

    public void commit() {

        UiContract contract = new UiContract();

        UiCopyrightHolder copyright = new UiCopyrightHolder();

        copyright.setKey(copyrightHolder.getSelectedItem());

        contract.setCopyrightHolder(copyright);

        UiContractType uiType = new UiContractType();

        uiType.setKey(type.getSelectedItem());

        uiType.setName(type.getItemText(type.getSelectedIndex()));

        contract.setType(uiType);

        contract.setKey(record.getContract().getKey());

        contract.setExternalId(externalIdTextBox.getText() != null ? externalIdTextBox.getText().trim() : null);

        contract.setActive(true);

        contract.setCreationDate(contractCreationDate.getDatePicker().getValue());

        contract.setEffectiveDate(contractEffectiveDate.getDatePicker().getValue());

        contract.setExpiryDate(contractExpiryDate.getDatePicker().getValue());

        if(expiryReminder.getValue() != null){

            contract.setDealExpiryReminder(new Long(expiryReminder.getValue().toString()));

        }

        contract.setName(name.getText().trim());

        contract.setUiContactList(contactListPanel.getUiContactList());

        contract.setUiDocumentList(documentsList);

        updateUserDefinedFieldsValuesFromForm(userDefinedFieldValueList);

        contract.setUserDefinedFieldsValues(userDefinedFieldValueList);

        contract.setUiDealsList(record.getContract().getUiDealsList());

        record.setContract(contract);

    }



    private void createUpdateUserDefinedFieldValues() {

        for ( UiUserDefinedField uiUserDefinedField : widgetCustomFieldMap.values() ) {

            UiUserDefinedFieldValue uiUserDefinedFieldValue = findUiUserDefinedFieldValue(

                    uiUserDefinedField.getIdUserDefinedField(), record.getContract().getUserDefinedFieldsValues() );

            if ( uiUserDefinedFieldValue == null ) {

                uiUserDefinedFieldValue = new UiUserDefinedFieldValue();

                uiUserDefinedFieldValue.setIdUserDefinedField( uiUserDefinedField.getIdUserDefinedField() );

                uiUserDefinedFieldValue.setValue( uiUserDefinedField.getDefaultValue() );

                record.getContract().getUserDefinedFieldsValues().add( uiUserDefinedFieldValue );

            }

        }

    }



    private UiUserDefinedFieldValue findUiUserDefinedFieldValue( Long idUserDefinedField,

            List<UiUserDefinedFieldValue> userDefinedFieldsValues ) {

        UiUserDefinedFieldValue uiUserDefinedFieldValue = null;

        for ( UiUserDefinedFieldValue fieldValue : userDefinedFieldsValues ) {

            if ( fieldValue.getIdUserDefinedField() != null

                    && fieldValue.getIdUserDefinedField().equals( idUserDefinedField ) ) {

                uiUserDefinedFieldValue = fieldValue;

                break;

            }

        }

        return uiUserDefinedFieldValue;

    }





    protected void updateUserDefinedFieldsValuesFromForm(Collection<UiUserDefinedFieldValue> oldValuesList) {

        Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

        for (Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {

            DataTypeWidget<?> dataTypeWidget = entry.getKey();

            UiUserDefinedField userDefinedField = entry.getValue();

            UiUserDefinedFieldValue userDefinedFieldValue = getValueForFieldType(oldValuesList, userDefinedField

                    .getIdUserDefinedField());

            if (userDefinedFieldValue != null) {

                userDefinedFieldValue.setValue(dataTypeWidget.getTextValue());

            }

        }

    }



    protected void updateFormFromUserDefinedFieldValues(Collection<UiUserDefinedFieldValue> newValuesList) {



        Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

        for (Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {

            DataTypeWidget<?> dataTypeWidget = entry.getKey();

            UiUserDefinedField userDefinedField = entry.getValue();

            UiUserDefinedFieldValue userDefinedFieldValue = getValueForFieldType(newValuesList, userDefinedField

                    .getIdUserDefinedField());

            if (userDefinedFieldValue != null) {

                dataTypeWidget.setTextValue(userDefinedFieldValue.getValue());

            }

        }

    }



    private UiUserDefinedFieldValue getValueForFieldType(Collection<UiUserDefinedFieldValue> newValuesList,

            Long idUserDefinedField) {

        UiUserDefinedFieldValue userDefinedFieldValue = null;

        for (UiUserDefinedFieldValue newUserDefinedFieldValue : newValuesList) {

            Long newIdUserDefinedField = newUserDefinedFieldValue.getIdUserDefinedField();

            if (newIdUserDefinedField.equals(idUserDefinedField)) {

                userDefinedFieldValue = newUserDefinedFieldValue;

                break;

            }

        }



        return userDefinedFieldValue;

    }



    private void verifyPermissions(){

        if (ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_CREATE) && record.getKey() == null) {

            saveButton.setEnabled(true);

        }



        if(ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_CREATE) && record.getKey() != null){

            addButton.setEnabled(true);

        }



        if(ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_MODIFY) && record.getKey() != null){

            saveButton.setEnabled(true);

        }



        if(ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_DELETE) && record.getKey() != null){

            removeButton.setEnabled(true);

        }

    }





    @Override

    public UiContractRecord getRecord() {

        return record;

    }



    @Override

    public void revert() {

    }



    @Override

    public String getStyleName() {

        return null;

    }



    @Override

    public Widget getWidget() {

        return this;

    }



    @Override

    public void release() {

    }



    @Override

    public void saveFailed(Throwable throwable) {

        errorPanel.showMessage(throwable.getLocalizedMessage());

    }



    @Override

    protected void onUnload() {

        super.onUnload();

    }

}

