package com.ericsson.cms.contractmgmt.client.tab.copyrightholder;

import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class CopyrightHolderAnchorChangeListener implements AnchorChangeListener {

    // constants in the url e.g. ?copyrightHolderId=1
    private static String COPYRIGHT_HOLDER_ID = "id";
    private static String PARAMETER_DELIMITER = "&";
    private static String VALUE_DELIMITER = "=";
    private final CopyrightHolderListPanel widget;

    public CopyrightHolderAnchorChangeListener( CopyrightHolderListPanel listPanel ) {
        this.widget = listPanel;
    }

    @Override
    public void anchorChanged( String anchor ) {
        long copyrightHolderId = 0L;

        /* Check for anchor with title list id */
        if ( anchor != null && anchor.contains( COPYRIGHT_HOLDER_ID ) ) {
            widget.getCopyrightHolderTable().reset();

            // skip the first char
            anchor = anchor.substring( 5 );
            // extract the info from the url
            String[] params = anchor.split( PARAMETER_DELIMITER );
            for ( String p : params ) {
                String[] paramValue = p.split( VALUE_DELIMITER );
                if ( paramValue[0].equalsIgnoreCase( COPYRIGHT_HOLDER_ID ) ) {
                    copyrightHolderId = Long.parseLong( paramValue[1] );
                }
            }
            
            IContractManagerServiceAsync cmService = GWT.create( IContractManagerService.class );
            cmService.getCopyrightHolder(copyrightHolderId, new NeptuneAsyncCallback<UiCopyrightHolder>() {

                @Override
                public void onNeptuneFailure(Throwable caught) {
                     Window.alert( caught.getLocalizedMessage() );
                }

                @Override
                public void onNeptuneSuccess(UiCopyrightHolder result) {
                    widget.getCopyrightHolderTable().showDetailView(new UiCopyrightHolderRecord(result)); 
                }   
            
            } );
        } else {
            widget.clearMessages();
            widget.getCopyrightHolderTable().setAnchor( anchor );
        }
    }
}
