package com.ericsson.cms.contractmgmt.client.tab.copyrightholder;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;
import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;
import com.ericsson.cms.contractmgmt.client.Permissions;
import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;
import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;
import com.ericsson.cms.contractmgmt.client.tab.UiLongKeySerializer;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.AbstractDetailFeature;

/**
 * Handles detail view for a given copyright holder.
 * 
 * @author Daniel Paranhos
 * 
 */
public class CopyrightHolderDetailFeature extends AbstractDetailFeature<Long, UiCopyrightHolderRecord> {

    private final ContractComponentConstants constants = (ContractComponentConstants) GWT
            .create( ContractComponentConstants.class );
    
    private final IContractManagerServiceAsync contractManagerService = GWT.create( IContractManagerService.class );

    private final ContractComponentMessages messages = (ContractComponentMessages) GWT
            .create(ContractComponentMessages.class);
    
    private final CopyrightHolderListPanel parentPanel;

    public CopyrightHolderDetailFeature( CopyrightHolderListPanel parentPanel ) {
        super( new UiLongKeySerializer() );
        this.parentPanel = parentPanel;
    }

    @Override
    public void delete(List<UiCopyrightHolderRecord> records,
            final AsyncCallback<Void> callback) {
        if (records != null && !records.isEmpty()) {
            if (Window.confirm(messages.deleteCopyrightHolderConfirmation())) {
                List<UiCopyrightHolder> copyrightHolderList = new ArrayList<UiCopyrightHolder>();
                for (UiCopyrightHolderRecord record : records) {
                    copyrightHolderList.add(record.getCopyrightHolder());
                }

                contractManagerService.deleteCopyrightHolders(copyrightHolderList,
                        new NeptuneAsyncCallback<Boolean>() {

                            @Override
                            public void onNeptuneFailure(Throwable caught) {
                                parentPanel.getErrorPanel().showMessage( messages.deleteCopyrightHolderError() );
                                callback.onFailure(caught);
                            }

                            @Override
                            public void onNeptuneSuccess(Boolean result) {
                                parentPanel.getSuccessPanel().showMessage( messages.deleteCopyrightHolderSucceeded() );
                                callback.onSuccess(null);
                            }

                        });
            }
        } else {
            Window.alert(messages.noCopyrightHolderSelected());
        }
    }

    @Override
    public void getNew( AsyncCallback<UiCopyrightHolderRecord> callback ) {
        this.parentPanel.clearMessages();
        if ( callback != null ) {
            callback.onSuccess( new UiCopyrightHolderRecord( new UiCopyrightHolder()) );
        }
    }

    @Override
    public DetailView<Long, UiCopyrightHolderRecord> getView( UiCopyrightHolderRecord record,
            DetailViewCallback<Long, UiCopyrightHolderRecord> callback ) {
        this.parentPanel.clearMessages();
        CopyrightHolderDetailView view = new CopyrightHolderDetailView( record, callback );
        return view;
    }

    /*
     * The detail link is shown only if the user has asset view permissions and
     * the column is the name column.
     */
    @Override
    public boolean hasDetailLink( Column<?, UiCopyrightHolderRecord> column ) {
        return column.getDisplayName().equals( constants.copyrightHolderNameColumn() )
                && ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_VIEW );
    }

    @Override
    public void save( UiCopyrightHolderRecord record, final AsyncCallback<Void> callback ) {
    	contractManagerService.saveCopyrightHolder(record.getCopyrightHolder(), new NeptuneAsyncCallback<Boolean>() {

			@Override
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			@Override
			public void onNeptuneSuccess(Boolean result) {
			    parentPanel.getSuccessPanel().showMessage( messages.saveCopyrightHolderSucceeded() );
				callback.onSuccess(null);
			}
		});
    }

    @Override
    public boolean showCreateButton() {
        return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_CREATE );
    }

    @Override
    public boolean showDeleteButton() {
        return ClientAuthorizationManager.isAuthorized( Permissions.CONTRACT_DELETE );
    }
}
