package com.ericsson.cms.contractmgmt.client.tab.copyrightholder;



import java.util.ArrayList;

import java.util.Collection;

import java.util.HashMap;

import java.util.List;

import java.util.Map;

import java.util.Map.Entry;

import java.util.Set;



import com.ericsson.cms.contractmgmt.client.ContractComponentConstants;

import com.ericsson.cms.contractmgmt.client.ContractComponentMessages;

import com.ericsson.cms.contractmgmt.client.Permissions;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldFactory;

import com.ericsson.cms.contractmgmt.client.customfield.CustomFieldValidator;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedField;

import com.ericsson.cms.contractmgmt.client.customfield.UiUserDefinedFieldValue;

import com.ericsson.cms.contractmgmt.client.document.DocumentComponentFactory;

import com.ericsson.cms.contractmgmt.client.model.UiContactType;

import com.ericsson.cms.contractmgmt.client.model.UiContract;

import com.ericsson.cms.contractmgmt.client.model.UiCopyrightHolder;

import com.ericsson.cms.contractmgmt.client.model.UiDocument;

import com.ericsson.cms.contractmgmt.client.model.UiDocumentType;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerService;

import com.ericsson.cms.contractmgmt.client.rpc.IContractManagerServiceAsync;

import com.ericsson.cms.contractmgmt.client.tab.ContractFormContainer;

import com.ericsson.cms.contractmgmt.client.tab.ErrorPanel;

import com.ericsson.cms.contractmgmt.client.tab.SuccessPanel;

import com.ericsson.cms.contractmgmt.client.tab.contacts.ContactListPanel;

import com.google.gwt.core.client.GWT;

import com.google.gwt.event.dom.client.ClickEvent;

import com.google.gwt.event.dom.client.ClickHandler;

import com.google.gwt.i18n.client.DateTimeFormat;

import com.google.gwt.user.client.History;

import com.google.gwt.user.client.Window;

import com.google.gwt.user.client.ui.Composite;

import com.google.gwt.user.client.ui.FormPanel;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;

import com.google.gwt.user.client.ui.Widget;

import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;

import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.FlexTableContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.DataTypeWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedTextBoxWidget;

import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.StringConverter;

import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;



public class CopyrightHolderDetailView extends Composite implements DetailView<Long, UiCopyrightHolderRecord> {



    /** Styles **/

    private static final String TABLE_STYLE = "contract-PlatformTable";

    private static final String ROW_STYLE = "contract-PlatformTable-row";

    private static final String ROW_HEADER_STYLE = "contract-PlatformTable-row-header";

    private static final String ROW_BODY_STYLE = "contract-PlatformTable-row-body";

    private static final String CELL_STYLE = "contract-PlatformTable-cell";

    private static final String CELL_HEADER_STYLE = "contract-PlatformTable-cell-header";

    private static final String LINK_BEHAVIOUR = "contract-Link";



    private static final int COPYRIGHTHOLDER_NAME_MAX_LENGTH = 50;

    private static final int COPYRIGHTHOLDER_AFFILIATION_MAX_LENGTH = 50;

    private static final int COPYRIGHTHOLDER_ADDRESS_MAX_LENGTH = 100;

    private static final int COPYRIGHTHOLDER_EXTERNAL_ID_MAX_LENGTH = 100;

    private final ContractComponentConstants constants = (ContractComponentConstants) GWT

            .create(ContractComponentConstants.class);



    private final IContractManagerServiceAsync contractManagerService = GWT.create( IContractManagerService.class );

    private final ContractComponentMessages messages = (ContractComponentMessages) GWT

            .create(ContractComponentMessages.class);



    private final UiCopyrightHolderRecord record;

    private final DetailViewCallback<Long, UiCopyrightHolderRecord> callback;

    private final VerticalContainer mainContainer;

    private FormContainer contractsContainer;

    private ContractFormContainer formContainer;

    private ContractFormContainer formUserDefinedFields;



    private FlexTableContainer tableContracts;



    private ButtonWidget removeButton;

    private ButtonWidget addButton;

    private ButtonWidget saveButton;

    private ButtonWidget cancelButton;

    private CheckBoxWidget check;



    private final ContactListPanel contactListPanel = new ContactListPanel();



    private final SuccessPanel successPanel = new SuccessPanel();

    private final ErrorPanel errorPanel = new ErrorPanel();



    private TypedTextBoxWidget<String> externalIdTextBox;

    private TypedTextBoxWidget<String> name;

    private TypedTextBoxWidget<String> address1;

    private TypedTextBoxWidget<String> address2;

    private TypedTextBoxWidget<String> address3;

    private TypedTextBoxWidget<String> affiliation;



    private final HorizontalContainer buttonsContainer;



    private final FormPanel form ;



    private final DocumentComponentFactory documentComponent;



    private List<UiDocument> documentsList = new ArrayList<UiDocument>();

    private final List<UiUserDefinedFieldValue> userDefinedFieldValueList = new ArrayList<UiUserDefinedFieldValue>();



    private final Map<DataTypeWidget<?>, UiUserDefinedField> widgetCustomFieldMap = new HashMap<DataTypeWidget<?>, UiUserDefinedField>();



    private final BusyIndicator busyIndicator = new BusyIndicator();



    public CopyrightHolderDetailView(final UiCopyrightHolderRecord record,

            DetailViewCallback<Long, UiCopyrightHolderRecord> callback) {

        this.record = record;

        this.callback = callback;

        mainContainer = new VerticalContainer();

        mainContainer.add( successPanel );

        mainContainer.add( errorPanel );

        initWidget(mainContainer);

        busyIndicator.center();

        init();



        contactListPanel.setContactType(UiContactType.COPYRIGHT_HOLDER);



        mainContainer.add(formContainer);

        mainContainer.add(contactListPanel);

        documentComponent= new DocumentComponentFactory(record.getKey(), constants.copyrightHolderDocument(), UiDocumentType.COPYRIGHT_HOLDER, errorPanel);

        form = documentComponent.getDocumentPanel();

        mainContainer.add(form);

        mainContainer.add(formUserDefinedFields);



        buttonsContainer = new HorizontalContainer();

        buttonsContainer.setSpacing(5);

        mainContainer.add(buttonsContainer);

        addButtons();

        mainContainer.add(contractsContainer);



        if (record.getKey() != null) {

            busyIndicator.center();

            getContractList();

            contactListPanel.setParentId(record.getKey());

            contactListPanel.isEditing = true;

        }  else {

            getUserDefinedFields();

            contactListPanel.isEditing = false;

        }



        verifyPermissions();

        busyIndicator.hide();

    }



    private void getContractList(){

        contractManagerService.getCopyrightHolderContractList(record.getKey(), new NeptuneAsyncCallback<List<UiContract>>() {



            @Override

            public void onNeptuneFailure(Throwable caught) {

                errorPanel.showMessage(caught.getLocalizedMessage());

            }



            @Override

            public void onNeptuneSuccess(List<UiContract> result) {

                record.getCopyrightHolder().setUiContractList(result);

                getUserDefinedFields();

                documentsList = record.getCopyrightHolder().getUiDocumentList();

                documentComponent.setDocumentsList(documentsList);

                fillForm();

            }

        });

    }



    private void getUserDefinedFields(){

        contractManagerService.getUserDefinedFields(CustomFieldFactory.COPYRIGHT_HOLDER_SCREEN, new NeptuneAsyncCallback<List<UiUserDefinedField>>() {



            @Override

            public void onNeptuneFailure(Throwable caught) {

                errorPanel.showMessage(caught.getLocalizedMessage());

            }



            @Override

            public void onNeptuneSuccess(List<UiUserDefinedField> result) {

                CustomFieldFactory factory = new CustomFieldFactory(null);

                factory.addFieldsToForm( formUserDefinedFields, result, widgetCustomFieldMap );

                for (UiUserDefinedField uiUserDefinedField : result) {

                    UiUserDefinedFieldValue value = new UiUserDefinedFieldValue();

                    value.setIdUserDefinedField(uiUserDefinedField.getIdUserDefinedField());

                    if(record.getKey() == null){

                        value.setValue(uiUserDefinedField.getDefaultValue());

                    }

                    userDefinedFieldValueList.add(value);

                }

                createUpdateUserDefinedFieldValues();

                if(record.getCopyrightHolder().getUserDefinedFieldsValues() != null){

                    updateFormFromUserDefinedFieldValues(record.getCopyrightHolder().getUserDefinedFieldsValues());

                }

            }

        });

    }



    private void fillForm(){

        externalIdTextBox.setValue(record.getCopyrightHolder().getExternalId());

        name.setValue(record.getCopyrightHolder().getName());

        String address[] = record.getCopyrightHolder().getAddress().split("\n");

        this.address1.setValue(address[0]);

        if(address.length >= 2){

            this.address2.setValue(address[1]);

        }



        if(address.length >= 3){

            this.address3.setValue(address[2]);

        }



        affiliation.setValue(record.getCopyrightHolder().getAffiliation());

        contactListPanel.getContactTable().refresh();



        for(UiDocument doc: documentsList){

            documentComponent.addRow(doc);

        }



        fillContractTable(record.getCopyrightHolder().getUiContractList());



    }



    private void init() {

        buildInfo();

        buildDisclosureContracts();

    }



    private void buildInfo() {



        formContainer = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);

        formUserDefinedFields = new ContractFormContainer(HasHorizontalAlignment.ALIGN_LEFT);

        externalIdTextBox = new TypedTextBoxWidget<String>(new StringConverter());

        externalIdTextBox.setMaxLength(COPYRIGHTHOLDER_EXTERNAL_ID_MAX_LENGTH);

        name = new TypedTextBoxWidget<String>(new StringConverter());

        name.setMaxLength(COPYRIGHTHOLDER_NAME_MAX_LENGTH);

        name.ensureDebugId("copyright-name");

        address1 = new TypedTextBoxWidget<String>(new StringConverter());

        address1.setMaxLength(COPYRIGHTHOLDER_ADDRESS_MAX_LENGTH);

        address1.ensureDebugId("copyright-address");

        address2 = new TypedTextBoxWidget<String>(new StringConverter());

        address2.setMaxLength(COPYRIGHTHOLDER_ADDRESS_MAX_LENGTH);

        address3 = new TypedTextBoxWidget<String>(new StringConverter());

        address3.setMaxLength(COPYRIGHTHOLDER_ADDRESS_MAX_LENGTH);

        affiliation = new TypedTextBoxWidget<String>(new StringConverter());

        affiliation.setMaxLength(COPYRIGHTHOLDER_AFFILIATION_MAX_LENGTH);

        affiliation.ensureDebugId("copyright-affiliation");



        formContainer.addRow(constants.externalID(), externalIdTextBox);

        formContainer.addRow(constants.copyrightHolderName(), name, true);

        formContainer.addRow(constants.copyrightHolderAddress(), address1, true);

        formContainer.addRow("", address2);

        formContainer.addRow("", address3);

        formContainer.addRow(constants.copyrightHolderAffiliation(), affiliation, true);

    }



    private void addHeading(String heading, FlexTableContainer table) {

        /* Add the column to the header row */

        int column = table.getCellCount(0);

        table.insertCell(0, column);



        /* Update the style of the header cells */

        table.getFlexCellFormatter().setStyleName(0, column, CELL_STYLE);

        table.getFlexCellFormatter().setStyleName(0, column, CELL_HEADER_STYLE);



        updateHeading(table, heading, column);

    }



    private void updateHeading(FlexTableContainer table, String heading, int column) {

        /* Create new label widget or update existing widget */

        LabelWidget label = getHeadingWidget(table, column);

        if (label == null) {

            /* Update the widget displayed as the column header */

            label = new LabelWidget(heading);

            label.addStyleName(TableConstants.STYLE_HEADER_NONSORTABLE_COL_TEXT);

            table.setWidget(0, column, label);

        } else {

            label.setText(heading);

        }

    }



    private LabelWidget getHeadingWidget(FlexTableContainer table, int column) {

        Widget widget = table.getWidget(0, column);

        return widget instanceof LabelWidget ? (LabelWidget) widget : null;

    }



    private void addButtons() {

        saveButton = new ButtonWidget(constants.saveButtonName(), new ClickHandler() {



            @Override

            public void onClick(ClickEvent event) {

                if (validate()) {

                    commit();

                    CopyrightHolderDetailView.this.callback.save(CopyrightHolderDetailView.this);

                }

            }

        });

        saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);

        saveButton.setEnabled(false);

        saveButton.ensureDebugId("copyright-save");

        buttonsContainer.add(saveButton);



        cancelButton = new ButtonWidget(constants.cancelButtonName(), new ClickHandler() {

            @Override

            public void onClick(ClickEvent event) {

                errorPanel.reset();

                callback.cancel(CopyrightHolderDetailView.this);

            }

        });

        cancelButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);

        buttonsContainer.add(cancelButton);

    }



    private void buildDisclosureContracts() {

        contractsContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);

        tableContracts = new FlexTableContainer();

        tableContracts.addStyleName(TABLE_STYLE);



        // Create the header row

        tableContracts.insertRow(0);

        tableContracts.getRowFormatter().addStyleName(0, ROW_STYLE);

        tableContracts.getRowFormatter().addStyleName(0, ROW_HEADER_STYLE);



        createTableContractsHeader();

        contractsContainer.addRow(constants.contractContract(),tableContracts);

        addButtonsContracts();

    }





    private void fillContractTable(List<UiContract> result) {

        if(result != null){

            for(UiContract contract: result){

                addRowContracts(contract);

            }

        }

    }



    private void addRowContracts(UiContract contract){



        insertRow();

        int row = getRow();



        tableContracts.getRowFormatter().setStyleName(row, TableConstants.STYLE_DATA_EVEN_ROW);



        DateTimeFormat format = DateTimeFormat.getFormat(constants.dateFormat());





        check = new CheckBoxWidget();

        tableContracts.setWidget(row, 0, check);



        LabelWidget link = new LabelWidget();

        link.setText(contract.getName());

        final String url = "Contracts.Contract.Edit?contractId=" + record.getCopyrightHolder().getUiContractList().get(row-1).getKey();

        link.addClickHandler(new ClickHandler() {



            @Override

            public void onClick(ClickEvent event) {

                History.newItem(url);

            }

        });

        link.setStyleName(LINK_BEHAVIOUR);

        tableContracts.setWidget(row, 1, link);



        LabelWidget label = new LabelWidget();

        label.setText(contract.getType().getName());

        tableContracts.setWidget(row, 2, label);





        label = new LabelWidget();

        label.setText(format.format(contract.getExpiryDate()));

        tableContracts.setWidget(row, 3, label);



    }



    private void insertRow(){

        tableContracts.insertRow(tableContracts.getRowCount());

        tableContracts.getRowFormatter().addStyleName(getRow(), ROW_STYLE);

        tableContracts.getRowFormatter().addStyleName(getRow(), ROW_BODY_STYLE);

    }



    private int getRow(){

        return tableContracts.getRowCount() - 1;

    }



    private void removeRow(){

        List<UiContract> deleteList = new ArrayList<UiContract>();

        for(int i = 1; i < tableContracts.getRowCount(); i++){

            if(((CheckBoxWidget)tableContracts.getWidget(i, 0)).getValue()){

                deleteList.add(record.getCopyrightHolder().getUiContractList().get(i-1));

            }

        }



        if(deleteList.size() == 0){

            Window.alert(messages.noContractSelected());

        } else {

            busyIndicator.center();

            contractManagerService.deleteContracts(deleteList, new NeptuneAsyncCallback<Boolean>() {



                @Override

                public void onNeptuneFailure(Throwable caught) {

                    errorPanel.showMessage(caught.getLocalizedMessage());

                    busyIndicator.hide();

                }



                @Override

                public void onNeptuneSuccess(Boolean result) {

                    for(int i = 1; i < tableContracts.getRowCount(); i++){

                        if(((CheckBoxWidget)tableContracts.getWidget(i, 0)).getValue()){

                            tableContracts.removeRow(i);

                            record.getCopyrightHolder().getUiContractList().remove(i-1);

                            i = i - 1;

                        }

                    }

                    if(((CheckBoxWidget)tableContracts.getWidget(0, 0)).getValue()){

                        ((CheckBoxWidget)tableContracts.getWidget(0, 0)).setValue(false);

                    }

                    busyIndicator.hide();

                }

            });

        }

    }



    private void createTableContractsHeader() {



        final CheckBoxWidget checkBox = new CheckBoxWidget();

        checkBox.addClickHandler(new ClickHandler() {



            @Override

            public void onClick(ClickEvent event) {

                for(int i = 1; i < tableContracts.getRowCount(); i++){

                    if(checkBox.getValue()){

                        ((CheckBoxWidget)tableContracts.getWidget(i, 0)).setValue(true);

                    } else {

                        ((CheckBoxWidget)tableContracts.getWidget(i, 0)).setValue(false);

                    }

                }

            }

        });



        tableContracts.insertCell(0, 0);

        tableContracts.getRowFormatter().setStyleName(0, TableConstants.STYLE_HEADER_ROW);

        tableContracts.getCellFormatter().addStyleName(0, 0, CELL_STYLE);

        tableContracts.getCellFormatter().addStyleName(0, 0, CELL_HEADER_STYLE);

        tableContracts.setWidget(0, 0, checkBox);



        addHeading(constants.contractName(), tableContracts);

        addHeading(constants.contractType(), tableContracts);

        addHeading(constants.contractExpiryDate(), tableContracts);



    }



    private void addButtonsContracts() {

        HorizontalContainer buttons = new HorizontalContainer();

        buttons.setSpacing(5);



        addButton = new ButtonWidget(constants.addButtonName(), new ClickHandler() {



            @Override

            public void onClick(ClickEvent event) {

                History.newItem("Contracts.Contract.Create?copyrightId=" + record.getKey());

            }



        });

        addButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);

        addButton.setEnabled(false);



        removeButton = new ButtonWidget(constants.removeButtonName(), new ClickHandler() {



            @Override

            public void onClick(ClickEvent event) {

                removeRow();

            }



        });

        removeButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);

        removeButton.setEnabled(false);

        buttons.add(addButton);

        buttons.add(removeButton);



        contractsContainer.addRow("",buttons);



    }



    private boolean validate() {

        errorPanel.reset();

        boolean valid = formContainer.validate() && formUserDefinedFields.validate();



        if(!valid){

            errorPanel.addHeading1(constants.copyrightHolderValidationMessage());

        }



        Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

        for (Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {

            DataTypeWidget<?> dataTypeWidget = entry.getKey();

            CustomFieldValidator.validate(dataTypeWidget, entry.getValue());

            if (!dataTypeWidget.isValidValue() || dataTypeWidget.hasValidationError()) {

                valid = false;

            }

        }



        return valid;

    }





    @Override

    public void commit() {

        UiCopyrightHolder copyright = new UiCopyrightHolder();

        if(record.getKey() != null){

            copyright.setKey(record.getCopyrightHolder().getKey());

        }

        copyright.setExternalId(externalIdTextBox.getText() != null ? externalIdTextBox.getText().trim() : null);

        copyright.setName(name.getText().trim());

        copyright.setAddress(address1.getText() + "\n" + address2.getText()+ "\n" + address3.getText());

        copyright.setAffiliation(affiliation.getText());

        copyright.setUiContactList(contactListPanel.getUiContactList());

        copyright.setUiDocumentList(documentsList);

        updateUserDefinedFieldsValuesFromForm(userDefinedFieldValueList);

        copyright.setUserDefinedFieldsValues(userDefinedFieldValueList);

        copyright.setUiContractList(record.getCopyrightHolder().getUiContractList());

        record.setCopyrightHolder(copyright);

    }



    private void createUpdateUserDefinedFieldValues() {

        for ( UiUserDefinedField uiUserDefinedField : widgetCustomFieldMap.values() ) {

            UiUserDefinedFieldValue uiUserDefinedFieldValue = findUiUserDefinedFieldValue(

                    uiUserDefinedField.getIdUserDefinedField(), record.getCopyrightHolder().getUserDefinedFieldsValues() );

            if ( uiUserDefinedFieldValue == null ) {

                uiUserDefinedFieldValue = new UiUserDefinedFieldValue();

                uiUserDefinedFieldValue.setIdUserDefinedField( uiUserDefinedField.getIdUserDefinedField() );

                uiUserDefinedFieldValue.setValue( uiUserDefinedField.getDefaultValue() );

                record.getCopyrightHolder().getUserDefinedFieldsValues().add( uiUserDefinedFieldValue );

            }

        }

    }



    private UiUserDefinedFieldValue findUiUserDefinedFieldValue( Long idUserDefinedField,

            List<UiUserDefinedFieldValue> userDefinedFieldsValues ) {

        UiUserDefinedFieldValue uiUserDefinedFieldValue = null;

        for ( UiUserDefinedFieldValue fieldValue : userDefinedFieldsValues ) {

            if ( fieldValue.getIdUserDefinedField() != null

                    && fieldValue.getIdUserDefinedField().equals( idUserDefinedField ) ) {

                uiUserDefinedFieldValue = fieldValue;

                break;

            }

        }

        return uiUserDefinedFieldValue;

    }



    protected void updateUserDefinedFieldsValuesFromForm(Collection<UiUserDefinedFieldValue> oldValuesList) {

        Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

        for (Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {

            DataTypeWidget<?> dataTypeWidget = entry.getKey();

            UiUserDefinedField userDefinedField = entry.getValue();

            UiUserDefinedFieldValue userDefinedFieldValue = getValueForFieldType(oldValuesList, userDefinedField

                    .getIdUserDefinedField());

            if (userDefinedFieldValue != null) {

                userDefinedFieldValue.setValue(dataTypeWidget.getTextValue());

            }

        }

    }



    protected void updateFormFromUserDefinedFieldValues(Collection<UiUserDefinedFieldValue> newValuesList) {



        Set<Entry<DataTypeWidget<?>, UiUserDefinedField>> entrySet = widgetCustomFieldMap.entrySet();

        for (Entry<DataTypeWidget<?>, UiUserDefinedField> entry : entrySet) {

            DataTypeWidget<?> dataTypeWidget = entry.getKey();

            UiUserDefinedField userDefinedField = entry.getValue();

            UiUserDefinedFieldValue userDefinedFieldValue = getValueForFieldType(newValuesList, userDefinedField

                    .getIdUserDefinedField());

            if (userDefinedFieldValue != null) {

                dataTypeWidget.setTextValue(userDefinedFieldValue.getValue());

            }

        }

    }



    private UiUserDefinedFieldValue getValueForFieldType(Collection<UiUserDefinedFieldValue> newValuesList,

            Long idUserDefinedField) {

        UiUserDefinedFieldValue userDefinedFieldValue = null;

        for (UiUserDefinedFieldValue newUserDefinedFieldValue : newValuesList) {

            Long newIdUserDefinedField = newUserDefinedFieldValue.getIdUserDefinedField();

            if (newIdUserDefinedField.equals(idUserDefinedField)) {

                userDefinedFieldValue = newUserDefinedFieldValue;

                break;

            }

        }



        return userDefinedFieldValue;

    }



    private void verifyPermissions(){

        if (ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_CREATE) && record.getKey() == null) {

            saveButton.setEnabled(true);

        }



        if(ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_CREATE) && record.getKey() != null){

            addButton.setEnabled(true);

        }



        if(ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_MODIFY) && record.getKey() != null){

            saveButton.setEnabled(true);

        }



        if(ClientAuthorizationManager.isAuthorized(Permissions.CONTRACT_DELETE) && record.getKey() != null){

            removeButton.setEnabled(true);

        }

    }



    @Override

    public UiCopyrightHolderRecord getRecord() {

        return record;

    }



    @Override

    public void revert() {

    }



    @Override

    public String getStyleName() {

        return null;

    }



    @Override

    public Widget getWidget() {

        return this;

    }



    @Override

    public void release() {

    }



    @Override

    public void saveFailed(Throwable throwable) {

        errorPanel.addMessage(throwable.getLocalizedMessage());

    }



    @Override

    protected void onUnload() {

        super.onUnload();

    }

}

